<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profile;
use App\Models\Project;
use App\Models\ContactMessage;
use Illuminate\Support\Facades\Schema;

class DashboardController extends Controller
{
    public function index()
    {
        // Pastikan tabelnya ada (baru install sering belum migrate semua)
        $hasProfilesTable = Schema::hasTable('profiles');
        $hasProjectsTable = Schema::hasTable('projects');
        $hasMessagesTable = Schema::hasTable('contact_messages');

        $hasProfiles = $hasProfilesTable && Profile::query()->exists();

        // Ambil profil aktif kalau kolom is_active ada, kalau tidak ada ambil terbaru, kalau tidak ada -> null
        $profile = null;
        if ($hasProfilesTable) {
            if (Schema::hasColumn('profiles', 'is_active')) {
                $profile = Profile::where('is_active', true)->first();
            }
            if (!$profile) {
                $profile = Profile::latest('id')->first();
            }
        }

        // Statistik aman walau tabel/kolom belum ada
        $stats = [
            'projects_total' => $hasProjectsTable ? Project::count() : 0,
            'projects_pub'   => ($hasProjectsTable && Schema::hasColumn('projects', 'published_at'))
                ? Project::whereNotNull('published_at')->count()
                : 0,
            'messages_total' => $hasMessagesTable ? ContactMessage::count() : 0,
        ];

        // List terbaru (selalu berupa Collection)
        $latestProjects = collect();
        if ($hasProjectsTable) {
            $q = Project::query();
            if (Schema::hasColumn('projects', 'published_at')) {
                $q->whereNotNull('published_at')->latest('published_at');
            } else {
                $q->latest('id');
            }
            $latestProjects = $q->take(5)->get();
        }

        $latestMessages = $hasMessagesTable
            ? ContactMessage::latest('id')->take(5)->get()
            : collect();

        return view('backend.dashboard', compact(
            'profile', 'hasProfiles', 'stats', 'latestProjects', 'latestMessages'
        ));
    }
}
