<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class PasswordConfirmController extends Controller
{
    public function show()
    {
        // View: resources/views/auth/confirm-password.blade.php
        return view('backend.auth.confirm-password', ['title' => 'Konfirmasi Password']);
    }

    public function store(Request $request)
    {
        $request->validate([
            'password' => ['required', 'string'],
        ]);

        $user = $request->user();

        if (! $user || ! Hash::check($request->password, $user->password)) {
            return back()->withErrors([
                'password' => 'Password tidak sesuai.',
            ]);
        }

        // Tandai sudah konfirmasi password (dipakai oleh middleware RequirePassword)
        $request->session()->put('auth.password_confirmed_at', time());

        // Kembali ke tujuan semula (intended)
        return redirect()->intended();
    }
}
