<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Profile;
use App\Models\Skill;
use App\Models\Experience;

class AboutController extends Controller
{
    public function show()
    {
        // profil & skills
        $profile = Profile::query()->first();
        $skills  = Skill::query()
            ->where('is_active', true)
            ->orderBy('name')
            ->get();

        // pengalaman kerja:
        // 1) yang masih berjalan (ended_at NULL) di atas
        // 2) lalu urut terbaru berdasarkan started_at
        // 3) tie-breaker id desc
        $experiences = Experience::query()
            ->where('is_active', true)
            ->orderByRaw('ended_at IS NULL DESC')
            ->orderByDesc('started_at')
            ->orderByDesc('id')
            ->get();

        return view('frontend.about', compact('profile', 'skills', 'experiences'));
    }
}
