<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Video;
use Illuminate\Http\Request;

class VideoController extends Controller
{
    public function index(Request $request)
    {
        $q = $request->query('q','');
        $videos = Video::query()
            ->where('is_public', true)
            ->published()
            ->search($q)
            ->latest('published_at')
            ->paginate(12)
            ->withQueryString();

        return view('frontend.videos.index', compact('videos','q'));
    }

    public function show(Video $video)
    {
        abort_unless($video->is_public && $video->published_at && $video->published_at <= now(), 404);
        return view('frontend.videos.show', compact('video'));
    }
}
