<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Visitor;
use Symfony\Component\HttpFoundation\Cookie;

class TrackUniqueVisitor
{
    public function handle(Request $request, Closure $next)
    {
        // Hanya track halaman publik (opsional, kamu bisa biarkan semua)
        if ($request->is('admin*') || $request->ajax()) {
            return $next($request);
        }

        $response = $next($request);

        try {
            $cookieName = 'dv'; // device id
            $deviceId   = $request->cookies->get($cookieName) ?: Str::uuid()->toString();

            $ua = (string) substr($request->userAgent() ?? 'unknown', 0, 255);
            $ip = (string) $request->getClientIp();
            // Hash gabungan supaya stabil per device+UA (deviceId mencegah dobel antar-browser)
            $deviceHash = hash('sha256', $deviceId.'|'.$ua);

            $visitor = Visitor::firstOrNew(['device_hash' => $deviceHash]);
            if (!$visitor->exists) {
                $visitor->device_id  = $deviceId;
                $visitor->user_agent = $ua;
                $visitor->ip         = $ip;
                $visitor->first_seen = now();
                $visitor->last_seen  = now();
                $visitor->visits     = 1;
                $visitor->save();
            } else {
                // Jangan nambah pengunjung untuk device yang sama → hanya update metadata & +visits
                $visitor->last_seen = now();
                $visitor->visits    = (int) $visitor->visits + 1;
                $visitor->save();
            }

            // Pastikan cookie device terset (2 tahun)
            if (!$request->cookies->has($cookieName)) {
                $response->headers->setCookie(
                    new Cookie($cookieName, $deviceId, now()->addYears(2), '/', null, false, true, false, Cookie::SAMESITE_LAX)
                );
            }
        } catch (\Throwable $e) {
            // diamkan, jangan ganggu user
        }

        return $response;
    }
}
