<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Str;

class Cv extends Model
{
    use HasFactory;

    protected $fillable = [
        'title','slug','file_path','summary','published_at',
    ];

    protected $casts = [
        'published_at' => 'datetime',
    ];

    public function getRouteKeyName(): string { return 'slug'; }

    public function getUrlAttribute(): string {
        return $this->file_path ? asset('storage/'.$this->file_path) : '';
    }

    public function scopePublished($q) {
        return $q->whereNotNull('published_at')->where('published_at','<=',now());
    }

    public function scopeSearch($q, ?string $term) {
        $term = trim((string)$term);
        if ($term==='') return $q;
        return $q->where(function($w) use ($term){
            $w->where('title','like',"%{$term}%")
              ->orWhere('summary','like',"%{$term}%")
              ->orWhere('slug','like',"%{$term}%");
        });
    }

    protected static function booted(): void {
        static::saving(function (Cv $cv){
            if (!$cv->slug && $cv->title) {
                $base = Str::slug(Str::limit($cv->title, 80, '')) ?: Str::random(8);
                $slug = $base; $i = 2;
                while (static::where('slug',$slug)->whereKeyNot($cv->getKey())->exists()) {
                    $slug = $base.'-'.$i++;
                }
                $cv->slug = $slug;
            }
        });
    }
}
