<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Experience extends Model
{
    protected $fillable = [
        'company', 'title', 'location',
        'started_at', 'ended_at',
        'description', 'is_active',
    ];

    protected $casts = [
        'started_at' => 'date',
        'ended_at'   => 'date',
        'is_active'  => 'boolean',
    ];

    /* Scopes */
    public function scopeActive($q)  { return $q->where('is_active', true); }

    // NOTE: tidak pakai 'is_current' lagi
    public function scopeOrdered($q)
    {
        // ended_at IS NULL (true=1) → pengalaman “current” di atas,
        // lalu paling baru berdasar started_at, lalu id.
        return $q->orderByRaw('ended_at IS NULL DESC')
                 ->orderByDesc('started_at')
                 ->orderByDesc('id');
    }

    /* Helpers */
    public function getPeriodLabelAttribute(): string
    {
        $start = $this->started_at?->format('Y');
        $end   = $this->ended_at?->format('Y') ?? 'Sekarang';
        return $start && $end ? "{$start} — {$end}" : ($start ?: '');
    }

    // accessor tetap boleh, tapi jangan dipakai untuk ORDER BY
    public function getIsCurrentAttribute(): bool
    {
        return $this->ended_at === null;
    }
}
