<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Profile extends Model
{
    use HasFactory;

    protected $fillable = [
        'name','headline','about_short','about_long',
        'email','phone',
        'location','lat','lng',
        'github','linkedin','x',
        'avatar_path','cv_path',
        'is_active','is_public','theme',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_public' => 'boolean',
        'lat'       => 'float',
        'lng'       => 'float',
    ];

    // Accessor untuk URL avatar
    public function getAvatarUrlAttribute(): ?string
    {
        return $this->avatar_path ? asset('storage/'.$this->avatar_path) : null;
    }

    public function getCvUrlAttribute(): ?string
    {
        return $this->cv_path ? asset('storage/'.$this->cv_path) : null;
    }
}
