<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('headline')->nullable(); // ex: Full-Stack Web Developer
            $table->text('about_short')->nullable();
            $table->longText('about_long')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('location')->nullable();
            $table->string('cv_url')->nullable(); // jika tidak pakai media lib
            // sosmed umum
            $table->string('github')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('x')->nullable(); // twitter/x
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profiles');
    }
};
