<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('profiles', function (Blueprint $table) {
            // path file; 512 biar aman (kalau suatu saat path agak panjang)
            if (!Schema::hasColumn('profiles', 'avatar_path')) {
                $table->string('avatar_path', 512)->nullable()->after('x');
            }
        });
    }

    public function down(): void
    {
        Schema::table('profiles', function (Blueprint $table) {
            if (Schema::hasColumn('profiles', 'avatar_path')) {
                $table->dropColumn('avatar_path');
            }
           
        });
    }
};
