<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('experiences', function (Blueprint $table) {
            $table->id();
            $table->string('company', 150);
            $table->string('title', 150);
            $table->string('location', 150)->nullable();
            $table->date('started_at');
            $table->date('ended_at')->nullable(); // null = masih berjalan
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index(['is_active', 'started_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('experiences');
    }
};


