<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('project_media', function (Blueprint $t) {
            $t->id();
            $t->foreignId('project_id')->constrained()->cascadeOnDelete();
            $t->string('kind', 10);                 // 'image' | 'video'
            $t->string('path');                     // storage path
            $t->string('thumb_path')->nullable();   // optional
            $t->string('caption')->nullable();
            $t->unsignedInteger('sort_order')->default(0);
            $t->boolean('is_cover')->default(false);
            $t->timestamps();

            $t->index(['project_id','sort_order']);
            $t->index(['project_id','is_cover']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('project_media');
    }
};
