<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('visitors', function (Blueprint $table) {
            $table->id();
            $table->string('device_hash', 64)->unique(); // identitas device (cookie + UA)
            $table->string('device_id', 64)->nullable(); // nilai cookie dv (plain)
            $table->string('user_agent', 255)->nullable();
            $table->string('ip', 64)->nullable();
            $table->unsignedBigInteger('visits')->default(0);
            $table->timestamp('first_seen')->nullable();
            $table->timestamp('last_seen')->nullable();
            $table->timestamps();

            $table->index(['last_seen']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('visitors');
    }
};
