<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            $table->string('title', 200);
            $table->string('slug', 220)->unique();
            $table->text('description')->nullable();
            $table->string('file_path', 255);      // storage path (public disk)
            $table->string('thumb_path', 255)->nullable(); // optional poster/thumbnail
            $table->unsignedInteger('duration')->nullable(); // seconds
            $table->boolean('is_public')->default(true);
            $table->timestamp('published_at')->nullable()->index();
            $table->json('tags')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('videos');
    }
};
