<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('cvs', function (Blueprint $table) {
            $table->id();
            $table->string('title', 200);
            $table->string('slug', 220)->unique();
            $table->string('file_path'); // public storage path
            $table->text('summary')->nullable();
            $table->timestamp('published_at')->nullable(); // null = Unpublish
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('cvs');
    }
};
