// resources/js/app.js
import './bootstrap'

// ===================== EasyMDE (Markdown Editor) =====================
import 'easymde/dist/easymde.min.css'
import EasyMDE from 'easymde'

function initEasyMDE() {
  document.querySelectorAll('textarea[data-editor="easymde"]').forEach((el) => {
    // hindari inisialisasi ganda jika pakai PJAX/Livewire/Turbo
    if (el.dataset.easymdeInitialized) return
    el.dataset.easymdeInitialized = '1'

    new EasyMDE({
      element: el,
      spellChecker: false,
      status: false,
      minHeight: '140px',
      // contoh opsi tambahan:
      // placeholder: 'Tulis deskripsi (Markdown didukung)…',
      // autosave: { enabled: true, uniqueId: el.name || 'desc', delay: 1000 },
      // toolbar: ['bold','italic','heading','|','quote','unordered-list','ordered-list','|','link','image','preview','guide'],
    })
  })
}

// ===================== UI: Mobile Menu Toggle =====================
function initMobileMenu() {
  const btn = document.getElementById('menuBtn')
  const menuMobile = document.getElementById('menuMobile')
  if (!btn || !menuMobile) return

  btn.addEventListener('click', () => {
    const hidden = menuMobile.classList.contains('hidden')
    menuMobile.classList.toggle('hidden', !hidden)
  })
}

// ===================== Scroll Reveal (IntersectionObserver) =====================
let revealObserver
function initReveal() {
  // tambahkan atribut pada elemen umum bila belum ada
  document
    .querySelectorAll('section, .card, .reveal')
    .forEach((el) => el.setAttribute('data-reveal', ''))

  // siapkan observer satu kali
  if (!revealObserver) {
    revealObserver = new IntersectionObserver(
      (entries) => {
        entries.forEach((e) => {
          if (e.isIntersecting) {
            e.target.classList.add('opacity-100', 'translate-y-0')
            e.target.style.transition =
              'opacity .6s ease-out, transform .6s ease-out'
            revealObserver.unobserve(e.target)
          }
        })
      },
      { threshold: 0.15 }
    )
  }

  // apply ke semua target
  document.querySelectorAll('[data-reveal]').forEach((el) => {
    // state awal
    el.classList.add('opacity-0', 'translate-y-3')
    revealObserver.observe(el)
  })
}

// ===================== Init on load (and re-load) =====================
function boot() {
  initEasyMDE()
  initMobileMenu()
  initReveal()
}

// DOMContentLoaded
document.addEventListener('DOMContentLoaded', boot)

// Dukungan untuk framework yang re-render halaman tanpa full reload (opsional):
// Livewire v3
document.addEventListener('livewire:navigated', boot)
// Turbo (Hotwire)
// document.addEventListener('turbo:load', boot)
// Inertia.js
// document.addEventListener('inertia:finish', boot)
