@extends('backend.layouts.app')

@section('content')
@php
  $selectedCats   = old('category_ids', []);
  $selectedSkills = old('skill_ids', []);
@endphp

<div class="mx-auto max-w-5xl">
  <div class="mb-6 flex items-center justify-between gap-3">
    <div>
      <div class="text-xs text-zinc-500">Dashboard / Projects / <span class="text-zinc-700">Create</span></div>
      <h1 class="text-2xl font-semibold mt-1">Tambah Project</h1>
      <p class="text-sm text-zinc-600">Isi detail project & unggah media (gambar / video).</p>
    </div>
    <a href="{{ route('admin.projects.index') }}" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl border hover:bg-zinc-50">
      ← Kembali
    </a>
  </div>

  @if (session('warning'))
    <div class="mb-4 rounded-xl border border-amber-200 bg-amber-50 text-amber-800 p-3 text-sm">
      {{ session('warning') }}
    </div>
  @endif

  @if ($errors->any())
    <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3 text-sm">
      <div class="font-medium mb-1">Periksa kembali:</div>
      <ul class="list-disc list-inside">
        @foreach ($errors->all() as $e)
          <li>{{ $e }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  <form action="{{ route('admin.projects.store') }}" method="POST" enctype="multipart/form-data"
        class="rounded-2xl border bg-white p-5 space-y-6" novalidate>
    @csrf

    @include('backend.projects.partials._form', [
      'project'        => $project,
      'allCategories'  => $allCategories,
      'allSkills'      => $allSkills,
      'selectedCats'   => $selectedCats,
      'selectedSkills' => $selectedSkills,
    ])

    <div class="flex flex-wrap items-center gap-3 pt-2">
      <button class="px-5 py-2.5 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 shadow-sm">Simpan Project</button>
      <a href="{{ route('admin.projects.index') }}" class="px-5 py-2.5 rounded-xl border hover:bg-zinc-50">Batal</a>
    </div>
  </form>
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="{{ Vite::asset('node_modules/easymde/dist/easymde.min.css') }}">
@endpush

@push('scripts')
@include('backend.projects.partials._form-js')
@endpush
