@extends('backend.layouts.app')

@section('content')
@php
  $selectedCats   = old('category_ids', $selectedCats ?? []);
  $selectedSkills = old('skill_ids', $selectedSkills ?? []);
@endphp

<div class="mx-auto max-w-5xl">
  <div class="mb-6 flex items-center justify-between gap-3">
    <div>
      <div class="text-xs text-zinc-500">Dashboard / Projects / <span class="text-zinc-700">Edit</span></div>
      <h1 class="text-2xl font-semibold mt-1">Edit Project</h1>
      <p class="text-sm text-zinc-600">Perbarui detail project & media.</p>
    </div>
    <a href="{{ route('admin.projects.index') }}" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl border hover:bg-zinc-50">
      ← Kembali
    </a>
  </div>

  @if (session('warning'))
    <div class="mb-4 rounded-xl border border-amber-200 bg-amber-50 text-amber-800 p-3 text-sm">
      {{ session('warning') }}
    </div>
  @endif

  @if ($errors->any())
    <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3 text-sm">
      <div class="font-medium mb-1">Periksa kembali:</div>
      <ul class="list-disc list-inside">
        @foreach ($errors->all() as $e)
          <li>{{ $e }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  <form action="{{ route('admin.projects.update', $project) }}" method="POST" enctype="multipart/form-data"
        class="rounded-2xl border bg-white p-5 space-y-6" novalidate>
    @csrf
    @method('PUT')

    @include('backend.projects.partials._form', [
      'project'        => $project,
      'allCategories'  => $allCategories,
      'allSkills'      => $allSkills,
      'selectedCats'   => $selectedCats,
      'selectedSkills' => $selectedSkills,
    ])

    {{-- Existing media grid --}}
    @if($project->media->count())
      <div class="pt-2">
        <div class="text-sm font-medium mb-2">Media saat ini</div>
        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3">
          @foreach($project->media as $m)
            <div class="relative rounded-xl border overflow-hidden">
              @if($m->kind === 'image')
                <img src="{{ asset('storage/'.$m->path) }}" class="w-full h-36 object-cover" alt="">
              @elseif($m->kind === 'video')
                <video src="{{ asset('storage/'.$m->path) }}" class="w-full h-36 object-cover" controls></video>
              @else
                <div class="h-36 grid place-items-center text-xs text-zinc-500 px-2 text-center">File</div>
              @endif
              <div class="p-2 flex items-center justify-between text-xs">
                <span class="truncate">{{ basename($m->path) }}</span>
                @if($m->is_cover)
                  <span class="px-2 py-0.5 rounded bg-emerald-100 text-emerald-700">Cover</span>
                @endif
              </div>
            </div>
          @endforeach
        </div>
      </div>
    @endif

    <div class="flex flex-wrap items-center gap-3 pt-2">
      <button class="px-5 py-2.5 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 shadow-sm">Simpan Perubahan</button>
      <a href="{{ route('admin.projects.index') }}" class="px-5 py-2.5 rounded-xl border hover:bg-zinc-50">Batal</a>
    </div>
  </form>
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="{{ Vite::asset('node_modules/easymde/dist/easymde.min.css') }}">
@endpush

@push('scripts')
@include('backend.projects.partials._form-js')
@endpush
