@extends('backend.layouts.app')

@section('content')
<div class="max-w-6xl">
  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
    <div>
      <div class="text-xs text-zinc-500">Dashboard / <span class="text-zinc-700">Projects</span></div>
      <h1 class="text-2xl font-semibold mt-1">Projects</h1>
      <p class="text-sm text-zinc-600">Kelola project, publikasi, media, dan metadata.</p>
    </div>

    <div class="flex gap-2">
      <form method="GET" class="flex items-stretch gap-2">
        <input type="text" name="q" value="{{ request('q') }}" placeholder="Cari judul/klien…"
               class="px-3 py-2 rounded-xl border w-64">
        <button class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Cari</button>
        @if(request('q'))
          <a href="{{ route('admin.projects.index') }}" class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Reset</a>
        @endif
      </form>

      <a href="{{ route('admin.projects.create') }}"
         class="px-4 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700">
        + Tambah Project
      </a>
    </div>
  </div>

  @if (session('success'))
    <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3 text-sm">
      {{ session('success') }}
    </div>
  @endif

  <div class="rounded-2xl border bg-white overflow-hidden">
    <div class="hidden md:block overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead>
          <tr class="border-b bg-zinc-50 text-zinc-600">
            <th class="py-2 px-3 text-left">Judul</th>
            <th class="py-2 px-3 text-left w-40">Klien</th>
            <th class="py-2 px-3 text-left w-40">Publish</th>
            <th class="py-2 px-3 text-left w-28">Status</th>
            <th class="py-2 px-3 text-right w-56">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @forelse($projects as $p)
            <tr class="border-b last:border-0 hover:bg-zinc-50/50">
              <td class="py-3 px-3 align-top">
                <div class="font-medium">{{ $p->title }}</div>
                <div class="text-xs text-zinc-500">/{{ $p->slug }}</div>
              </td>
              <td class="py-3 px-3 align-top">{{ $p->client ?: '—' }}</td>
              <td class="py-3 px-3 align-top">
                @if($p->published_at)
                  <div class="text-zinc-800">{{ $p->published_at->format('d M Y') }}</div>
                  <div class="text-xs text-zinc-500">{{ $p->published_at->format('H:i') }}</div>
                @else
                  <span class="text-zinc-500">Draft</span>
                @endif
              </td>
              <td class="py-3 px-3 align-top">
                <div class="flex items-center gap-2">
                  @if($p->published_at)
                    <span class="px-2 py-1 text-xs rounded bg-emerald-100 text-emerald-700">Published</span>
                  @else
                    <span class="px-2 py-1 text-xs rounded bg-zinc-100 text-zinc-700">Draft</span>
                  @endif
                  @if($p->is_featured)
                    <span class="px-2 py-1 text-xs rounded bg-indigo-100 text-indigo-700">Featured</span>
                  @endif
                </div>
              </td>
              <td class="py-3 px-3 align-top">
                <div class="flex justify-end gap-2">
                  {{-- Toggle Featured --}}
                  <form action="{{ route('admin.projects.toggle-featured', $p) }}" method="POST">
                    @csrf @method('PATCH')
                    <button class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">
                      {{ $p->is_featured ? 'Unfeature' : 'Feature' }}
                    </button>
                  </form>

                  {{-- Publish/Unpublish --}}
                  <form action="{{ route('admin.projects.publish', $p) }}" method="POST">
                    @csrf @method('PATCH')
                    <button class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">
                      {{ $p->published_at ? 'Unpublish' : 'Publish' }}
                    </button>
                  </form>

                  <a href="{{ route('admin.projects.edit', $p) }}"
                     class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">Edit</a>

                  <form action="{{ route('admin.projects.destroy', $p) }}" method="POST"
                        onsubmit="return confirm('Hapus project ini?')">
                    @csrf @method('DELETE')
                    <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50 text-xs">
                      Hapus
                    </button>
                  </form>
                </div>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="5" class="py-14 text-center text-zinc-600">
                <div class="text-3xl mb-1">📁</div>
                Belum ada project.
              </td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- Mobile --}}
    <div class="md:hidden divide-y">
      @forelse($projects as $p)
        <div class="p-4 space-y-2">
          <div class="flex items-center justify-between gap-3">
            <div class="min-w-0">
              <div class="font-semibold truncate">{{ $p->title }}</div>
              <div class="text-xs text-zinc-500 truncate">/{{ $p->slug }}</div>
            </div>
            <div class="text-right">
              @if($p->published_at)
                <span class="px-2 py-1 text-xs rounded bg-emerald-100 text-emerald-700">Published</span>
              @else
                <span class="px-2 py-1 text-xs rounded bg-zinc-100 text-zinc-700">Draft</span>
              @endif
            </div>
          </div>
          <div class="text-sm text-zinc-600">Klien: {{ $p->client ?: '—' }}</div>
          <div class="flex flex-wrap gap-2 pt-1">
            <form action="{{ route('admin.projects.toggle-featured', $p) }}" method="POST">
              @csrf @method('PATCH')
              <button class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">
                {{ $p->is_featured ? 'Unfeature' : 'Feature' }}
              </button>
            </form>
            <form action="{{ route('admin.projects.publish', $p) }}" method="POST">
              @csrf @method('PATCH')
              <button class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">
                {{ $p->published_at ? 'Unpublish' : 'Publish' }}
              </button>
            </form>
            <a href="{{ route('admin.projects.edit', $p) }}"
               class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">Edit</a>
            <form action="{{ route('admin.projects.destroy', $p) }}" method="POST"
                  onsubmit="return confirm('Hapus project ini?')">
              @csrf @method('DELETE')
              <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50 text-xs">
                Hapus
              </button>
            </form>
          </div>
        </div>
      @empty
        <div class="p-10 text-center text-zinc-600">
          <div class="text-3xl mb-1">📁</div>
          Belum ada project.
        </div>
      @endforelse
    </div>
  </div>

  @if($projects instanceof \Illuminate\Contracts\Pagination\Paginator && $projects->hasPages())
    <div class="mt-5">
      {{ $projects->withQueryString()->links() }}
    </div>
  @endif
</div>
@endsection
