<script>
(function () {
  // ===== Auto-slug =====
  const title = document.getElementById('title');
  const slug  = document.getElementById('slug');
  if (title && slug) {
    const toSlug = (s) => (s || '')
      .toLowerCase().normalize('NFD').replace(/[\u0300-\u036f]/g,'')
      .replace(/[^a-z0-9]+/g,'-').replace(/^-+|-+$/g,'').substring(0, 220);
    title.addEventListener('input', () => {
      if (!slug.value || slug.dataset.touched !== '1') slug.value = toSlug(title.value);
    });
    slug.addEventListener('input', () => slug.dataset.touched = '1');
  }

  // ===== EasyMDE =====
  document.addEventListener('DOMContentLoaded', () => {
    const el = document.getElementById('project-content');
    if (el && window.EasyMDE) {
      new window.EasyMDE({
        element: el,
        spellChecker: false,
        minHeight: '260px',
        status: false,
        autoDownloadFontAwesome: false,
        placeholder: 'Tulis konten project…',
        toolbar: [
          'bold','italic','heading','|',
          'quote','unordered-list','ordered-list','|',
          'link','image','code','|',
          'preview','guide'
        ],
      });
    }
  });

  // ===== Filter skill + pilih semua/kosongkan =====
  (function () {
    const filter = document.getElementById('skillFilter');
    const grid   = document.getElementById('skillsGrid');
    const btnAll = document.getElementById('skillsSelectAll');
    const btnClr = document.getElementById('skillsClear');
    if (!grid) return;

    function applyFilter() {
      const q = (filter?.value || '').trim().toLowerCase();
      // Sembunyikan/hilangkan hanya label (kartu checkbox), jangan tombol tambah
      grid.querySelectorAll('label').forEach(lab => {
        const txt = lab.textContent.trim().toLowerCase();
        lab.classList.toggle('hidden', q && !txt.includes(q));
      });
      // Toggle area "skill baru" jika semua label tersembunyi
      showAreaIfEmpty();
    }

    filter?.addEventListener('input', applyFilter);

    btnAll?.addEventListener('click', () => {
      grid.querySelectorAll('label input[type="checkbox"]').forEach(cb => cb.checked = true);
    });
    btnClr?.addEventListener('click', () => {
      grid.querySelectorAll('label input[type="checkbox"]').forEach(cb => cb.checked = false);
    });

    // ===== Tambah skill baru (Lainnya) =====
    const addBtn   = document.getElementById('addSkillBtn');
    const area     = document.getElementById('newSkillArea');
    const input    = document.getElementById('newSkillInput');
    const chipsBox = document.getElementById('newSkillChips');

    function addNewSkillChip(name) {
      const val = (name || '').trim();
      if (!val) return;

      // Cegah duplikat antar chip baru
      const chipExists = Array.from(chipsBox?.querySelectorAll('input[name="skills_new[]"]') || [])
        .some(h => h.value.toLowerCase() === val.toLowerCase());
      // Cegah duplikat dengan skill lama
      const oldExists = Array.from(grid.querySelectorAll('label span'))
        .some(s => s.textContent.trim().toLowerCase() === val.toLowerCase());
      if (chipExists || oldExists) return;

      const chip = document.createElement('span');
      chip.className = 'chip';
      chip.innerHTML = `
        <input type="hidden" name="skills_new[]" value="${val}">
        <span>${val}</span>
        <button type="button" title="Hapus">✕</button>
      `;
      chip.querySelector('button')?.addEventListener('click', () => chip.remove());
      chipsBox?.appendChild(chip);
    }

    addBtn?.addEventListener('click', () => {
      area?.classList.toggle('hidden');
      if (!area?.classList.contains('hidden')) input?.focus();
    });

    input?.addEventListener('keydown', (e) => {
      if (e.key === 'Enter' || e.key === ',') {
        e.preventDefault();
        addNewSkillChip(input.value.replace(/,$/, ''));
        input.value = '';
      }
    });

    input?.addEventListener('blur', () => {
      if (input.value.trim()) {
        addNewSkillChip(input.value.trim());
        input.value = '';
      }
    });

    function showAreaIfEmpty() {
      if (!area) return;
      const anyVisible = Array.from(grid.querySelectorAll('label'))
        .some(lab => !lab.classList.contains('hidden'));
      // Jika tidak ada hasil, tampilkan area skill baru
      area.classList.toggle('hidden', anyVisible);
    }

    // Inisialisasi awal
    applyFilter();
  })();

  // ===== Media Uploader (preview + cover + hapus sebelum submit) =====
  (function () {
    const drop = document.getElementById('dropzone');
    const input = document.getElementById('media');
    const grid = document.getElementById('mediaPreview');
    const coverField = document.getElementById('cover_filename');

    if (!drop || !input || !grid) return;

    let fileList = [];
    const keyOf = (f) => `${f.name}__${f.size}__${f.lastModified}`;

    function addFiles(newFiles) {
      const map = new Map(fileList.map(f => [keyOf(f), f]));
      Array.from(newFiles).forEach(f => map.set(keyOf(f), f));
      fileList = Array.from(map.values());
      syncInput(); render();
    }

    function removeFile(key) {
      fileList = fileList.filter(f => keyOf(f) !== key);
      if (!fileList.some(f => f.name === coverField.value)) {
        coverField.value = fileList[0]?.name || '';
      }
      syncInput(); render();
    }

    function syncInput() {
      const dt = new DataTransfer();
      fileList.forEach(f => dt.items.add(f));
      input.files = dt.files;
    }

    function render() {
      grid.innerHTML = '';
      if (!fileList.length) return;
      if (!coverField.value) coverField.value = fileList[0].name;

      fileList.forEach(file => {
        const url = URL.createObjectURL(file);
        const isVideo = file.type.startsWith('video');
        const isImage = file.type.startsWith('image');
        const wrapper = document.createElement('div');
        wrapper.className = 'relative group rounded-xl border overflow-hidden bg-zinc-50';

        wrapper.innerHTML = `
          ${isImage ? `<img src="${url}" class="w-full h-36 object-cover" alt="">`
                    : isVideo ? `<video src="${url}" class="w-full h-36 object-cover" muted playsinline></video>`
                              : `<div class="h-36 grid place-items-center text-xs text-zinc-500 px-2 text-center">Format tidak didukung</div>`}
          <div class="absolute inset-x-0 bottom-0 p-2 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition">
            <div class="flex items-center justify-between gap-2">
              <span class="px-2 py-0.5 rounded text-xs bg-white/85 line-clamp-1">${file.name}</span>
              <div class="flex items-center gap-2">
                <button type="button" data-cover="${file.name}" class="px-2 py-1 rounded text-[11px] bg-amber-200/95 hover:bg-amber-300">Jadikan Cover</button>
              </div>
            </div>
          </div>
          <button type="button" title="Hapus"
            class="absolute top-1 right-1 w-7 h-7 grid place-items-center rounded-full bg-white/90 border hover:bg-rose-50 hover:text-rose-600 transition"
            data-remove="${keyOf(file)}">✕</button>
        `;

        if (coverField.value === file.name) wrapper.setAttribute('data-is-cover', '1');

        wrapper.querySelector('button[data-cover]')?.addEventListener('click', (ev) => {
          coverField.value = ev.currentTarget.getAttribute('data-cover') || '';
          grid.querySelectorAll('[data-is-cover]').forEach(el => el.removeAttribute('data-is-cover'));
          wrapper.setAttribute('data-is-cover', '1');
        });

        wrapper.querySelector('button[data-remove]')?.addEventListener('click', (ev) => {
          removeFile(ev.currentTarget.getAttribute('data-remove'));
        });

        grid.appendChild(wrapper);
      });
    }

    drop.addEventListener('click', (e) => {
      if (e.target === drop || e.target.closest('.inline-flex')) input.click();
    });

    ['dragenter','dragover'].forEach(evt => {
      drop.addEventListener(evt, e => { e.preventDefault(); drop.classList.add('border-indigo-400'); });
    });
    ['dragleave','drop'].forEach(evt => {
      drop.addEventListener(evt, e => { e.preventDefault(); drop.classList.remove('border-indigo-400'); });
    });

    drop.addEventListener('drop', (e) => {
      const files = e.dataTransfer?.files;
      if (files && files.length) addFiles(files);
    });

    input.addEventListener('change', () => {
      if (input.files?.length) addFiles(input.files);
      // input.value = ''; // tidak perlu reset, sudah disinkronkan via DataTransfer
    });
  })();
})();
</script>

<style>
  /* Cover highlight */
  #mediaPreview [data-is-cover] { outline: 3px solid rgb(251 191 36); }

  /* Chip skill baru */
  .chip{
    display:inline-flex; align-items:center; gap:.5rem;
    border:1px solid rgb(228 228 231);
    background:#fff; padding:.25rem .5rem; border-radius:9999px; font-size:.875rem;
  }
  .chip button{ line-height:1; }
</style>
