@php
    $project ??= new \App\Models\Project();
@endphp

<div class="grid md:grid-cols-2 gap-4">
    <div>
        <label class="text-sm">Judul</label>
        <input id="title" name="title" value="{{ old('title', $project->title) }}" required
            class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">
    </div>
    <div>
        <label class="text-sm">Slug</label>
        <input id="slug" name="slug" value="{{ old('slug', $project->slug) }}"
            class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">
        <p class="text-xs text-zinc-500 mt-1">Otomatis dari judul (boleh diubah).</p>
    </div>
</div>

<div class="grid md:grid-cols-2 gap-4">
    <div>
        <label class="text-sm">Klien (opsional)</label>
        <input name="client" value="{{ old('client', $project->client) }}"
            class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">
    </div>
    <div>
        <label class="text-sm">Tanggal Publish (opsional)</label>
        <input type="datetime-local" name="published_at"
            value="{{ old('published_at', $project->published_at ? $project->published_at->format('Y-m-d\TH:i') : '') }}"
            class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">
    </div>
</div>

<div>
    <label class="text-sm">Ringkasan</label>
    <textarea name="summary" rows="3" data-editor="easymde"
        class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">{{ old('summary', $project->summary) }}</textarea>
</div>

<div>
    <label class="text-sm">Konten (Markdown didukung)</label>
    <textarea id="project-content" name="content" rows="10" data-editor="easymde"
        class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">{{ old('content', $project->content) }}</textarea>
</div>

<div class="grid md:grid-cols-2 gap-6">
    <div>
        <label class="text-sm">Kategori (opsional)</label>
        <select name="category_ids[]" multiple
            class="w-full mt-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">
            @foreach ($allCategories ?? [] as $cat)
                <option value="{{ $cat->id }}" @selected(in_array($cat->id, $selectedCats ?? []))>
                    {{ $cat->name }}
                </option>
            @endforeach
        </select>
        <p class="text-xs text-zinc-500 mt-1">Tahan Ctrl/Cmd untuk memilih banyak.</p>
    </div>

    <div>
        <label class="text-sm">Skills (boleh lebih dari satu)</label>

        <input id="skillFilter" type="text" placeholder="Cari skill…"
            class="w-full mt-1 mb-2 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">

        <div id="skillsGrid" class="grid sm:grid-cols-2 md:grid-cols-3 gap-2">
            @foreach ($allSkills ?? [] as $sk)
                @php $checked = in_array($sk->id, $selectedSkills ?? []); @endphp
                <label class="group cursor-pointer">
                    {{-- PENTING: gunakan skills[] agar match dengan controller --}}
                    <input type="checkbox" name="skills[]" value="{{ $sk->id }}" class="sr-only peer"
                        @checked($checked)>
                    <span
                        class="block w-full rounded-xl border px-3 py-2 text-sm
                     bg-white peer-checked:bg-indigo-600 peer-checked:text-white
                     peer-checked:border-indigo-600 hover:bg-zinc-50">
                        {{ $sk->name }}
                    </span>
                </label>
            @endforeach

            {{-- Kartu "Tambah skill baru" --}}
            <button type="button" id="addSkillBtn"
                class="rounded-xl border border-dashed px-3 py-2 text-sm hover:bg-zinc-50 text-left">
                + Tambah skill lain…
            </button>
        </div>

        {{-- Area input skill baru (hidden by default) --}}
        <div id="newSkillArea" class="mt-3 hidden">
            <div class="flex items-center gap-2">
                <input id="newSkillInput" type="text" placeholder="Ketik nama skill lalu tekan Enter"
                    class="flex-1 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500">
                <button type="button" id="newSkillHelp"
                    class="px-3 py-2 rounded-xl border text-sm hover:bg-zinc-50">?</button>
            </div>
            <p class="text-xs text-zinc-500 mt-1">
                Kamu bisa menambahkan beberapa skill. Tekan <kbd>Enter</kbd> atau koma (,) untuk menambahkan.
            </p>

            {{-- Chip skill baru yang sudah ditambahkan --}}
            <div id="newSkillChips" class="mt-2 flex flex-wrap gap-2"></div>
        </div>

        <div class="mt-2 flex items-center gap-2">
            <button type="button" id="skillsSelectAll"
                class="px-3 py-1.5 rounded-lg border hover:bg-zinc-50 text-sm">Pilih semua</button>
            <button type="button" id="skillsClear"
                class="px-3 py-1.5 rounded-lg border hover:bg-zinc-50 text-sm">Kosongkan</button>
        </div>
    </div>
</div>

<div class="grid md:grid-cols-2 gap-4">
    <div class="flex items-center justify-between rounded-xl border bg-zinc-50 px-4 py-3">
        <div>
            <div class="text-sm font-medium">Tampilkan di bagian Featured</div>
            <p class="text-xs text-zinc-600">Akan diberi prioritas tampil.</p>
        </div>
        <label class="inline-flex items-center cursor-pointer select-none">
            <input type="hidden" name="is_featured" value="0">
            <input type="checkbox" name="is_featured" value="1" class="h-4 w-4"
                {{ old('is_featured', (int) ($project->is_featured ?? 0)) ? 'checked' : '' }}>
            <span class="ml-2 text-sm">Featured</span>
        </label>
    </div>

    <div class="flex items-center justify-between rounded-xl border bg-zinc-50 px-4 py-3">
        <div>
            <div class="text-sm font-medium">Publish sekarang?</div>
            <p class="text-xs text-zinc-600">Jika dicentang, project langsung dipublish.</p>
        </div>
        <label class="inline-flex items-center cursor-pointer select-none">
            <input type="hidden" name="is_published" value="0">
            <input type="checkbox" name="is_published" value="1" class="h-4 w-4"
                {{ old('is_published', $project->published_at ? 1 : 0) ? 'checked' : '' }}>
            <span class="ml-2 text-sm">Publish</span>
        </label>
    </div>
</div>

{{-- ====== MEDIA UPLOADER ====== --}}
<div>
    <label class="text-sm font-medium">Media (Gambar / Video)</label>
    <input type="hidden" name="cover_filename" id="cover_filename" value="{{ old('cover_filename') }}">

    <div id="dropzone"
        class="mt-2 flex flex-col items-center justify-center rounded-2xl border border-dashed p-6 text-center
              hover:border-indigo-400 transition cursor-pointer">
        <div class="text-5xl leading-none select-none">🗂️</div>
        <p class="mt-2 text-sm text-zinc-700">Tarik & letakkan file ke sini, atau klik untuk memilih.</p>
        <p class="text-xs text-zinc-500">Menerima: JPG, PNG, WebP, MP4, WebM (maks ~50MB/berkas, bisa banyak).</p>
        <input id="media" type="file" name="media[]" class="hidden" multiple accept="image/*,video/*">
        <div class="mt-3 inline-flex items-center gap-2 px-3 py-1.5 rounded-lg border bg-white text-sm">Pilih Berkas…
        </div>
    </div>

    <div id="mediaPreview" class="mt-4 grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3"></div>
    <p class="text-xs text-zinc-500 mt-2">Klik “Jadikan Cover” pada salah satu media untuk menjadikannya cover. Jika
        tidak dipilih, sistem memakai media pertama.</p>
</div>
