<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>{{ $title ?? 'Masuk' }}</title>

  @vite(['resources/css/app.css'])

  {{-- Script reCAPTCHA (bahasa Indonesia) --}}
  {!! NoCaptcha::renderJs('id') !!}

  {{-- Responsif: skala reCAPTCHA di layar sempit agar tidak overflow --}}
  <style>
    .recaptcha-scale { transform-origin: 0 0; }
    @media (max-width: 380px){ .recaptcha-scale { transform: scale(.90); } }
    @media (max-width: 340px){ .recaptcha-scale { transform: scale(.82); } }
  </style>
</head>
<body class="min-h-dvh bg-zinc-50 text-zinc-900 antialiased">
  <main class="grid place-items-center px-4 py-10">
    <div class="w-full max-w-md">
      <header class="mb-8 text-center">
        <h1 class="text-2xl font-bold">Masuk Dashboard</h1>
        <p class="text-sm text-zinc-600">Selamat Datang Di Halaman Login</p>
      </header>

      @if ($errors->any())
        <div role="alert" class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3 text-sm">
          {{ $errors->first() }}
        </div>
      @endif

      <section class="rounded-2xl border bg-white p-6 shadow-sm">
        <form id="login-form" action="{{ route('login.submit') }}" method="POST" class="space-y-5" novalidate>
          @csrf

          {{-- Email --}}
          <div>
            <label for="email" class="text-sm font-medium">Email</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required
                   autocomplete="username"
                   class="mt-1 w-full px-3 py-2 border rounded-lg focus:ring-2 focus:ring-zinc-900" autofocus>
            @error('email') <p class="mt-1 text-sm text-rose-600">{{ $message }}</p> @enderror
          </div>

          {{-- Password --}}
          <div>
            <label for="password" class="text-sm font-medium">Password</label>
            <input id="password" type="password" name="password" required minlength="8"
                   autocomplete="current-password"
                   class="mt-1 w-full px-3 py-2 border rounded-lg focus:ring-2 focus:ring-zinc-900">
          </div>

          {{-- Remember --}}
          <div class="flex items-center justify-between">
            <label class="inline-flex items-center gap-2 text-sm">
              <input type="checkbox" name="remember" class="size-4 border rounded">
              Ingat saya
            </label>
          </div>

          {{-- ===== Verifikasi Keamanan (reCAPTCHA) ===== --}}
          <div class="rounded-xl border bg-zinc-50 p-4 sm:p-5">
            <div class="flex items-start gap-3 mb-3">
              {{-- shield-check icon --}}
              <svg class="h-5 w-5 mt-0.5 text-emerald-600" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                <path d="M12 2.25c.3 0 .6.07.86.22l6.66 3.7c.3.17.48.49.48.83V11c0 5.05-3.49 8.77-7.59 10.62a1.56 1.56 0 01-1.22 0C7.07 19.77 3.58 16.05 3.58 11V6.99c0-.34.18-.66.48-.83l6.66-3.7c.26-.15.56-.22.86-.22zM10.2 14.4l-2.1-2.1a.9.9 0 10-1.27 1.27l2.74 2.74a.9.9 0 001.27 0l5.53-5.53a.9.9 0 10-1.27-1.27l-4.9 4.89z"/>
              </svg>
              <div>
                <p class="text-sm font-medium">Verifikasi Keamanan</p>
                <p class="text-xs text-zinc-500">Centang kotak di bawah untuk melanjutkan.</p>
              </div>
            </div>

            {{-- Wrapper agar widget center + responsif --}}
            <div class="recaptcha-scale">
              <div class="flex justify-center">
                {!! NoCaptcha::display([
                    'data-theme' => 'light',
                    'data-callback' => 'onRecaptchaOK',
                    'data-expired-callback' => 'onRecaptchaExpired',
                    'data-error-callback' => 'onRecaptchaError'
                ]) !!}
              </div>
            </div>

            @error('g-recaptcha-response')
              <p class="mt-2 text-sm text-rose-600" aria-live="polite">{{ $message }}</p>
            @enderror
          </div>
          {{-- ===== /Verifikasi Keamanan ===== --}}

          <button id="submit-btn"
                  class="w-full px-4 py-2 rounded-xl bg-black text-white hover:opacity-90 disabled:opacity-50 disabled:cursor-not-allowed">
            Masuk
          </button>
        </form>
      </section>

      <p class="mt-6 text-center text-sm text-zinc-600">
        Kembali ke <a href="{{ url('/') }}" class="underline">beranda</a>
      </p>
    </div>
  </main>

  <script>
    // Nonaktifkan tombol sampai reCAPTCHA dicentang
    const submitBtn = document.getElementById('submit-btn');
    const form = document.getElementById('login-form');
    if (submitBtn) submitBtn.disabled = true;

    function onRecaptchaOK(){ if (submitBtn) submitBtn.disabled = false; }
    function onRecaptchaExpired(){ if (submitBtn) submitBtn.disabled = true; }
    function onRecaptchaError(){ if (submitBtn) submitBtn.disabled = true; }

    // Cegah double submit
    form?.addEventListener('submit', () => {
      if (submitBtn){ submitBtn.disabled = true; submitBtn.innerText = 'Memproses...'; }
    });
  </script>
</body>
</html>
