<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ $title ?? 'Daftar' }}</title>
  @vite(['resources/css/app.css'])
</head>
<body class="min-h-dvh bg-zinc-50 text-zinc-900 antialiased">
  <main class="grid place-items-center px-4 py-10">
    <div class="w-full max-w-md rounded-2xl border bg-white p-6 shadow-sm">
      <h1 class="text-xl font-semibold mb-4">Buat Akun</h1>

      @if ($errors->any())
        <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3 text-sm">
          {{ $errors->first() }}
        </div>
      @endif

      <form action="{{ route('register.submit') }}" method="POST" class="space-y-4">
        @csrf
        <div>
          <label class="text-sm">Nama</label>
          <input type="text" name="name" value="{{ old('name') }}" required class="mt-1 w-full px-3 py-2 border rounded focus:ring-2 focus:ring-zinc-900" autofocus>
        </div>
        <div>
          <label class="text-sm">Email</label>
          <input type="email" name="email" value="{{ old('email') }}" required class="mt-1 w-full px-3 py-2 border rounded focus:ring-2 focus:ring-zinc-900">
        </div>

        {{-- Password --}}
        <div class="relative">
          <label class="text-sm">Password</label>
          <input type="password" id="password" name="password" required class="mt-1 w-full px-3 py-2 border rounded pr-10 focus:ring-2 focus:ring-zinc-900">
          <button type="button" onclick="togglePassword('password', this)" class="absolute right-2 top-[34px] text-zinc-500 hover:text-zinc-700">
            <!-- eye icon (default) -->
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
            </svg>
          </button>
        </div>

        {{-- Konfirmasi Password --}}
        <div class="relative">
          <label class="text-sm">Konfirmasi Password</label>
          <input type="password" id="password_confirmation" name="password_confirmation" required class="mt-1 w-full px-3 py-2 border rounded pr-10 focus:ring-2 focus:ring-zinc-900">
          <button type="button" onclick="togglePassword('password_confirmation', this)" class="absolute right-2 top-[34px] text-zinc-500 hover:text-zinc-700">
            <!-- eye icon (default) -->
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
            </svg>
          </button>
        </div>

        <button class="w-full px-4 py-2 rounded-xl bg-black text-white hover:opacity-90">Daftar</button>
      </form>

      <p class="text-sm text-zinc-600 mt-4">
        Sudah punya akun? <a class="underline" href="{{ route('login') }}">Masuk</a>
      </p>
    </div>
  </main>

  <script>
    function togglePassword(inputId, btn) {
      const input = document.getElementById(inputId);
      const svg = btn.querySelector('svg');

      if (input.type === "password") {
        input.type = "text";
        // ganti ke eye-off
        svg.outerHTML = `
          <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a9.956 9.956 0 012.618-4.304m3.36-2.175A9.956 9.956 0 0112 5c4.478 0 8.268 2.943 9.542 7a9.956 9.956 0 01-4.278 5.223M15 12a3 3 0 11-6 0 3 3 0 016 0zM3 3l18 18" />
          </svg>
        `;
      } else {
        input.type = "password";
        // ganti ke eye
        svg.outerHTML = `
          <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
          </svg>
        `;
      }
    }
  </script>
</body>
</html>
