@extends('backend.layouts.app')

@section('content')
{{-- ===== Header ===== --}}
<div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-5">
  <div>
    <h1 class="text-2xl font-bold tracking-tight">Curriculum Vitae</h1>
    <p class="text-sm text-zinc-500">Kelola file CV yang akan ditampilkan publik.</p>
  </div>

  <a href="{{ route('admin.cvs.create') }}"
     class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-gradient-to-r from-indigo-600 to-fuchsia-600 text-white shadow hover:shadow-lg transition">
    <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none"><path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
    Upload CV
  </a>
</div>

{{-- ===== Search + Bulk actions ===== --}}
<div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-4">
  <form method="GET" class="w-full md:w-auto">
    <div class="relative md:w-[28rem]">
      <input name="q" value="{{ $q ?? '' }}" placeholder="Cari judul / slug…"
             class="w-full px-4 py-2.5 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500" />
      @if(($q ?? '') !== '')
        <a href="{{ route('admin.cvs.index') }}"
           class="absolute right-2 top-1/2 -translate-y-1/2 text-xs text-zinc-500 hover:underline">Clear</a>
      @endif
    </div>
  </form>

  {{-- Bulk delete form (tidak membungkus tabel) --}}
  <form id="bulkForm" method="POST" action="{{ route('admin.cvs.bulk-destroy') }}"
        onsubmit="return confirm('Hapus CV terpilih? Tindakan ini tidak bisa dibatalkan.');">
    @csrf
    <button id="bulkDeleteBtn" type="submit"
            class="inline-flex items-center gap-2 px-3 py-2 rounded-xl border bg-white text-sm shadow-sm disabled:opacity-50"
            disabled>
      <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none"><path d="M6 7h12M9 7V5a2 2 0 012-2h2a2 2 0 012 2v2M9 11v6M15 11v6M5 7l1 14a2 2 0 002 2h8a2 2 0 002-2l1-14" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
      Hapus terpilih <span id="bulkCount" class="ml-1">(0)</span>
    </button>
  </form>
</div>

{{-- ===== Table ===== --}}
<div class="overflow-x-auto rounded-2xl border bg-white shadow-sm">
  <table class="min-w-full text-sm">
    <thead class="bg-zinc-50 text-zinc-700">
      <tr>
        <th class="px-3 py-2">
          <input id="chk-all" type="checkbox" class="h-4 w-4">
        </th>
        <th class="px-3 py-2 text-left w-12">No</th>
        <th class="px-3 py-2 text-left">Judul</th>
        <th class="px-3 py-2 text-left hidden md:table-cell">Slug</th>
        <th class="px-3 py-2 text-left">Status</th>
        <th class="px-3 py-2 text-left hidden sm:table-cell">Dipublish</th>
        <th class="px-3 py-2 text-left hidden lg:table-cell">Diupdate</th>
        <th class="px-3 py-2 text-right w-1">Aksi</th>
      </tr>
    </thead>
    <tbody>
      @forelse($cvs as $cv)
        @php
          $rowNo = ($cvs->currentPage() - 1) * $cvs->perPage() + $loop->iteration;
        @endphp
        <tr class="border-t hover:bg-zinc-50">
          {{-- checkbox (masuk ke bulkForm via atribut form) --}}
          <td class="px-3 py-3 align-top">
            <input type="checkbox" class="h-4 w-4 row-chk"
                   name="ids[]" value="{{ $cv->id }}" form="bulkForm">
          </td>

          <td class="px-3 py-3 align-top text-zinc-600">{{ $rowNo }}</td>

          <td class="px-3 py-3 align-top">
            <div class="font-medium break-words">{{ $cv->title }}</div>
            @if($cv->summary)
              <div class="mt-0.5 text-xs text-zinc-500 line-clamp-1 max-w-[46ch]">{{ $cv->summary }}</div>
            @endif
            <div class="mt-1">
              <a href="{{ $cv->url }}" target="_blank"
                 class="inline-flex items-center gap-1 text-xs text-indigo-600 hover:underline">
                <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M14 3h7v7m0-7L10 14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
                Lihat file
              </a>
            </div>
          </td>

          <td class="px-3 py-3 align-top hidden md:table-cell text-zinc-600 break-all">
            {{ $cv->slug }}
          </td>

          <td class="px-3 py-3 align-top">
            <span class="inline-flex items-center gap-1.5 px-2 py-0.5 rounded-full text-xs border
                         {{ $cv->published_at ? 'bg-emerald-50 text-emerald-700 border-emerald-200' : 'bg-zinc-50 text-zinc-700 border-zinc-200' }}">
              <span class="w-1.5 h-1.5 rounded-full {{ $cv->published_at ? 'bg-emerald-500' : 'bg-zinc-400' }}"></span>
              {{ $cv->published_at ? 'Published' : 'Unpublished' }}
            </span>
          </td>

          <td class="px-3 py-3 align-top hidden sm:table-cell text-zinc-600">
            {{ $cv->published_at ? $cv->published_at->diffForHumans() : '—' }}
          </td>

          <td class="px-3 py-3 align-top hidden lg:table-cell text-zinc-600">
            {{ $cv->updated_at?->diffForHumans() }}
          </td>

          <td class="px-3 py-3 align-top">
            <div class="flex items-center justify-end gap-2">
              {{-- publish toggle --}}
              <form method="POST" action="{{ route('admin.cvs.publish',$cv) }}">
                @csrf @method('PATCH')
                <button class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg border bg-white text-xs hover:bg-zinc-50 transition">
                  @if($cv->published_at)
                    <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
                    Unpublish
                  @else
                    <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
                    Publish
                  @endif
                </button>
              </form>

              {{-- edit --}}
              <a href="{{ route('admin.cvs.edit',$cv) }}"
                 class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg border bg-white text-xs hover:bg-zinc-50 transition">
                Edit
              </a>

              {{-- delete satuan: tombol mengirim form khusus di bawah lewat atribut form --}}
              <button type="submit" form="del-{{ $cv->id }}"
                      class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg border bg-white text-xs text-rose-600 hover:bg-rose-50 transition"
                      onclick="return confirm('Hapus CV ini?')">
                Hapus
              </button>
            </div>
          </td>
        </tr>
      @empty
        <tr>
          <td colspan="8" class="px-3 py-8 text-center text-zinc-500">
            Belum ada data CV. Klik <a href="{{ route('admin.cvs.create') }}" class="underline">Upload CV</a>.
          </td>
        </tr>
      @endforelse
    </tbody>
  </table>
</div>

{{-- Pagination --}}
@if($cvs->hasPages())
  <div class="mt-4">
    {{ $cvs->links() }}
  </div>
@endif

{{-- ===== Hidden single-delete forms (diletakkan di luar tabel & bulk form) ===== --}}
@foreach($cvs as $cv)
  <form id="del-{{ $cv->id }}" method="POST" action="{{ route('admin.cvs.destroy',$cv) }}" class="hidden">
    @csrf @method('DELETE')
  </form>
@endforeach
@endsection

@push('scripts')
<script>
(function(){
  const chkAll = document.getElementById('chk-all');
  const checks = Array.from(document.querySelectorAll('.row-chk'));
  const btn    = document.getElementById('bulkDeleteBtn');
  const cnt    = document.getElementById('bulkCount');

  function refresh(){
    const n = checks.filter(c => c.checked).length;
    cnt.textContent = `(${n})`;
    btn.disabled = n === 0;
    // sinkron header check
    if (n === checks.length && checks.length) chkAll.checked = true;
    else chkAll.checked = false;
    // state indeterminate
    chkAll.indeterminate = (n > 0 && n < checks.length);
  }
  chkAll?.addEventListener('change', () => {
    checks.forEach(c => c.checked = chkAll.checked);
    refresh();
  });
  checks.forEach(c => c.addEventListener('change', refresh));
  refresh();
})();
</script>
@endpush
