@php $cv ??= new \App\Models\Cv(); @endphp

<div class="mb-3">
  <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full border bg-white shadow-sm text-xs text-zinc-600">
    <span class="w-1.5 h-1.5 rounded-full {{ $cv->exists ? 'bg-emerald-500' : 'bg-indigo-500' }}"></span>
    {{ $cv->exists ? 'Edit CV' : 'Upload CV' }}
  </div>
</div>

<div class="grid md:grid-cols-2 gap-4">
  <div>
    <label class="text-sm font-medium">Judul</label>
    <input id="cv-title" name="title" value="{{ old('title',$cv->title) }}" required maxlength="200"
           class="w-full mt-1 px-3 py-2 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500">
    <p class="text-xs text-zinc-500 mt-1">Contoh: “Curriculum Vitae 2025 (English)”.</p>
  </div>
  <div>
    <label class="text-sm font-medium">Slug (opsional)</label>
    <input id="cv-slug" name="slug" value="{{ old('slug',$cv->slug) }}" maxlength="220"
           class="w-full mt-1 px-3 py-2 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500"
           placeholder="otomatis dari judul">
  </div>
</div>

<div class="mt-4">
  <label class="text-sm font-medium">Ringkasan (opsional)</label>
  <textarea name="summary" rows="4"
            class="w-full mt-1 px-3 py-2 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500">{{ old('summary',$cv->summary) }}</textarea>
  <p class="text-xs text-zinc-500 mt-1">Maks 1000 karakter.</p>
</div>

<div class="mt-4">
  <label class="text-sm font-medium">File CV {{ $cv->exists ? '(biarkan kosong jika tidak diganti)' : '' }}</label>

  <div id="drop-cv"
       class="mt-1 flex flex-col items-center justify-center gap-2 rounded-2xl border border-dashed p-6 bg-white shadow-sm hover:border-indigo-400 transition cursor-pointer">
    <div class="text-4xl leading-none select-none">📄</div>
    <p class="text-sm text-zinc-700">Tarik & letakkan file PDF/DOC/DOCX ke sini, atau klik untuk memilih.</p>
    <p class="text-xs text-zinc-500">Maks 15MB.</p>
    <input id="file-cv" type="file" name="file" accept=".pdf,.doc,.docx,application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document" class="hidden">
  </div>

  <div id="preview-cv" class="mt-3">
    @if($cv->exists && $cv->url)
      {{-- Preview PDF apabila PDF, selain itu tampilkan link --}}
      @php $isPdf = \Illuminate\Support\Str::endsWith(strtolower($cv->file_path), '.pdf'); @endphp
      @if($isPdf)
        <iframe src="{{ $cv->url }}#toolbar=1" class="w-full h-72 rounded-xl border"></iframe>
      @else
        <a href="{{ $cv->url }}" target="_blank" class="text-indigo-600 underline text-sm">Buka CV saat ini</a>
      @endif
    @endif
  </div>
</div>

<div class="mt-4">
  <label class="text-sm font-medium">Status</label>
  <div class="flex items-center gap-3 mt-1">
    <input type="hidden" name="is_published" value="0">
    <label class="inline-flex items-center gap-2">
      <input type="checkbox" name="is_published" value="1" class="h-4 w-4"
             {{ old('is_published', $cv->published_at ? 1 : 0) ? 'checked' : '' }}>
      <span class="text-sm">Publish</span>
    </label>
    <span class="text-xs text-zinc-500">Uncheck = Unpublish</span>
  </div>
</div>

{{-- small CSS + scripts --}}
<style>.dz-hover{border-color:rgb(99,102,241)!important;background:#fafaff}</style>
@push('scripts')
<script>
(function(){
  // ---------- AUTO SLUG dari judul (lokal, tanpa translate)
  const t = document.getElementById('cv-title');
  const s = document.getElementById('cv-slug');
  if (t && s) {
    // otomatis jika slug kosong; kalau user mengubah slug, auto dimatikan
    let auto = !s.value;

    function toLocalSlug(str){
      return (str||'')
        .toLowerCase()
        .normalize('NFD').replace(/[\u0300-\u036f]/g,'')      // buang aksen/diakritik
        .replace(/[^\p{L}\p{N}\s-]+/gu,'')                    // sisakan huruf/angka/spasi/-
        .trim().replace(/\s+/g,'-')                           // spasi => '-'
        .replace(/-+/g,'-')                                   // rapikan multi '-'
        .slice(0,220);
    }

    const sync = ()=>{ if(auto) s.value = toLocalSlug(t.value); };
    t.addEventListener('input', sync);
    s.addEventListener('input', ()=>{ auto = false; });
    sync();
  }

  // ---------- Drag & drop preview
  function setupDrop(dropId, inputId, onFile){
    const dz = document.getElementById(dropId);
    const fi = document.getElementById(inputId);
    if(!dz || !fi) return;

    dz.addEventListener('click', e=>{ if(e.target===dz) fi.click(); });
    ['dragenter','dragover'].forEach(evt=>{
      dz.addEventListener(evt, e=>{ e.preventDefault(); dz.classList.add('dz-hover'); });
    });
    ['dragleave','drop'].forEach(evt=>{
      dz.addEventListener(evt, e=>{ e.preventDefault(); dz.classList.remove('dz-hover'); });
    });
    dz.addEventListener('drop', e=>{
      const files = e.dataTransfer?.files; if(files?.length){ fi.files = files; onFile(files[0]); }
    });
    fi.addEventListener('change', ()=>{ const f = fi.files?.[0]; if(f) onFile(f); });
  }

  setupDrop('drop-cv','file-cv', (file)=>{
    const box = document.getElementById('preview-cv');
    if(!box) return;
    const ext = (file.name||'').toLowerCase();
    const url = URL.createObjectURL(file);
    if (ext.endsWith('.pdf')) {
      box.innerHTML = `<iframe src="${url}#toolbar=1" class="w-full h-72 rounded-xl border"></iframe>`;
    } else {
      box.innerHTML = `<a href="${url}" target="_blank" class="text-indigo-600 underline text-sm">Preview file</a>`;
    }
  });
})();
</script>
@endpush
