@extends('backend.layouts.app')

@section('content')
@php
    use Illuminate\Support\Facades\Route as RouteFacade;

    // ===== Stats aman jika key tidak ada =====
    $projectsTotal = data_get($stats, 'projects_total', 0);
    $profileViews  = data_get($stats, 'profile_views', 0);   // <-- ganti "Published" jadi "Profile Views"
    $inboxTotal    = data_get($stats, 'messages_total', 0);

    // ===== Avatar fallback =====
    $avatar = $profile?->avatar_path
        ? asset('storage/' . $profile->avatar_path)
        : 'https://i.pravatar.cc/240?u=ammar';

    // ===== Rute create/edit profil (yang mungkin berbeda-beda) =====
    $createProfileUrl = RouteFacade::has('admin.profiles.create') ? route('admin.profiles.create') : '#';

    if (RouteFacade::has('admin.profile.edit')) {
        $editProfileUrl = route('admin.profile.edit');
    } elseif (RouteFacade::has('admin.profiles.edit') && $profile?->exists) {
        $editProfileUrl = route('admin.profiles.edit', $profile);
    } else {
        $editProfileUrl = $createProfileUrl; // fallback
    }

    // Basis tautan pengaturan (edit kalau sudah ada profil, jika belum arahkan ke create)
    $settingsBase = $hasProfiles ? $editProfileUrl : $createProfileUrl;
@endphp

@if (!$hasProfiles)
  <div class="mb-4 rounded-xl border border-amber-200 bg-amber-50 text-amber-800 p-3 text-sm">
    Belum ada data profil.
    <a class="underline" href="{{ $createProfileUrl }}">Buat profil pertama</a>
    agar website menampilkan identitas Anda.
  </div>
@endif

{{-- ===== Hero Section ===== --}}
<section class="relative overflow-hidden rounded-3xl border bg-gradient-to-tr from-indigo-50 via-sky-50 to-emerald-50 p-6 md:p-8">
  <div class="absolute -top-12 -left-12 h-56 w-56 rounded-full bg-indigo-200/40 blur-3xl"></div>
  <div class="absolute -bottom-16 -right-16 h-64 w-64 rounded-full bg-emerald-200/40 blur-3xl"></div>

  <div class="relative flex flex-col sm:flex-row items-start sm:items-center gap-4 sm:gap-6">
    <img src="{{ $avatar }}" class="w-20 h-20 md:w-24 md:h-24 rounded-2xl border object-cover shadow-sm" alt="Avatar">

    <div class="flex-1 min-w-0 w-full">
      <h1 class="text-2xl md:text-3xl font-bold tracking-tight break-words whitespace-normal">
        Selamat datang, {{ $profile->name ?? 'Ammar Azmi' }}
      </h1>

      <p class="text-zinc-600 mt-1 line-clamp-2 sm:line-clamp-1">
        {{ $profile->headline ?? 'Kelola profil & portofolio Anda.' }}
      </p>

      <div class="mt-4 flex flex-wrap gap-2">
        <a href="{{ $hasProfiles ? $editProfileUrl : $createProfileUrl }}"
           class="px-4 py-2 rounded-xl bg-black text-white hover:opacity-90 transition">
          {{ $hasProfiles ? 'Edit Profil' : 'Buat Profil' }}
        </a>
        <a href="{{ url('/') }}" target="_blank"
           class="px-4 py-2 rounded-xl border hover:bg-white transition">Lihat Situs</a>
      </div>
    </div>
  </div>
</section>

{{-- ===== 3 Kartu Stat ===== --}}
<section class="grid sm:grid-cols-3 gap-4 mt-6">
  <div class="rounded-2xl border bg-white p-5">
    <div class="text-sm text-zinc-500">Total Projects</div>
    <div class="text-3xl font-bold">{{ $projectsTotal }}</div>
  </div>

  <div class="rounded-2xl border bg-white p-5">
    <div class="text-sm text-zinc-500">Profile Views</div>
    <div class="text-3xl font-bold">{{ $profileViews }}</div>
  </div>

  <div class="rounded-2xl border bg-white p-5">
    <div class="text-sm text-zinc-500">Inbox Messages</div>
    <div class="text-3xl font-bold">{{ $inboxTotal }}</div>
  </div>
</section>

{{-- ===== Menu Cepat ===== --}}
<section class="mt-8">
  <div class="flex items-end justify-between gap-3 mb-3">
    <h2 class="text-xl font-semibold">Kelola Profil</h2>
    <form class="hidden sm:block">
      <input
        placeholder="Cari menu…"
        class="px-3 py-2 border rounded-lg w-64"
        oninput="
          const q=this.value.toLowerCase();
          document.querySelectorAll('[data-card]').forEach(c=>{
            c.classList.toggle('hidden', !c.dataset.card.includes(q));
          });
        ">
    </form>
  </div>

  <div class="grid md:grid-cols-2 xl:grid-cols-4 gap-4">
    {{-- Project --}}
    <a href="{{ route('admin.projects.index') }}" 
       data-card="project portfolio pekerjaan repositori link demo"
       class="group rounded-2xl border bg-white p-5 hover:border-black/20 hover:shadow-sm transition">
      <div class="flex items-start gap-3">
        <span class="rounded-xl border p-2 bg-zinc-50">📁</span>
        <div>
          <div class="font-semibold">Project</div>
          <p class="text-sm text-zinc-600">Kelola daftar project, link, dan deskripsi.</p>
        </div>
      </div>
    </a>

    {{-- Pekerjaan / Riwayat --}}
    <a href="{{ route('admin.experiences.index') }}"
       data-card="pekerjaan riwayat pengalaman kerja jabatan perusahaan"
       class="group rounded-2xl border bg-white p-5 hover:border-black/20 hover:shadow-sm transition">
      <div class="flex items-start gap-3">
        <span class="rounded-xl border p-2 bg-zinc-50">💼</span>
        <div>
          <div class="font-semibold">Pekerjaan / Riwayat</div>
          <p class="text-sm text-zinc-600">Tambahkan pengalaman kerja, posisi, dan periode.</p>
        </div>
      </div>
    </a>

    {{-- CV --}}
        <a href="{{ route('admin.cvs.index') }}"
       data-card="cv resume riwayat kerja pendidikan"
       class="group rounded-2xl border bg-white p-5 hover:border-black/20 hover:shadow-sm transition">
      <div class="flex items-start gap-3">
        <span class="rounded-xl border p-2 bg-zinc-50">📄</span>
        <div>
          <div class="font-semibold">CV</div>
          <p class="text-sm text-zinc-600">Unggah & perbarui CV (PDF).</p>
        </div>
      </div>
    </a>

    {{-- Banner / Video --}}
    <a href="{{ route('admin.videos.index') }}#banner-video"
       data-card="banner video header media hero"
       class="group rounded-2xl border bg-white p-5 hover:border-black/20 hover:shadow-sm transition">
      <div class="flex items-start gap-3">
        <span class="rounded-xl border p-2 bg-zinc-50">🎥</span>
        <div>
          <div class="font-semibold">Banner / Video</div>
          <p class="text-sm text-zinc-600">Atur banner gambar atau video profil.</p>
        </div>
      </div>
    </a>

    {{-- Skill & Tools --}}
    <a href="{{ route('admin.skills.index') }}"
       data-card="skill skills tools stack teknologi tech bahasa framework library"
       class="group rounded-2xl border bg-white p-5 hover:border-black/20 hover:shadow-sm transition">
      <div class="flex items-start gap-3">
        <span class="rounded-xl border p-2 bg-zinc-50">🛠️</span>
        <div>
          <div class="font-semibold">Skill &amp; Tools</div>
          <p class="text-sm text-zinc-600">Kelola skill, level, dan tools yang dikuasai.</p>
        </div>
      </div>
    </a>
  </div>
</section>

{{-- ===== Proyek Terbaru & Inbox ===== --}}
<section class="grid lg:grid-cols-3 gap-6 mt-8">
  {{-- Proyek Terbaru --}}
  <div class="lg:col-span-2 rounded-2xl border bg-white p-5">
    <div class="flex items-center justify-between mb-4">
      <h3 class="font-semibold">Proyek Terbaru</h3>
      @if (RouteFacade::has('projects.index'))
        <a href="{{ route('projects.index') }}" class="text-sm underline">Lihat semua</a>
      @endif
    </div>
    <div class="divide-y">
      @forelse($latestProjects as $p)
        @php
          $cover = $p->cover_path
              ? asset('storage/' . $p->cover_path)
              : 'https://picsum.photos/seed/cov/160/96';
          $date = $p->published_at ?? $p->created_at;
        @endphp
        <div class="py-3 flex items-center gap-4">
          <img src="{{ $cover }}" class="w-28 h-16 object-cover rounded-lg border" alt="">
          <div class="min-w-0">
            <div class="font-medium truncate">{{ $p->title }}</div>
            <div class="text-xs text-zinc-500">{{ optional($date)->format('d M Y') }}</div>
          </div>
          @if (RouteFacade::has('projects.show'))
            <a href="{{ route('projects.show', $p) }}" class="ml-auto text-sm underline">Buka</a>
          @endif
        </div>
      @empty
        <div class="text-sm text-zinc-500">Belum ada proyek.</div>
      @endforelse
    </div>
  </div>

  {{-- Inbox Pesan --}}
  <div class="rounded-2xl border bg-white p-5">
    <div class="flex items-center justify-between mb-4">
      <h3 class="font-semibold">Inbox Pesan</h3>
      @if (RouteFacade::has('admin.messages.index'))
        <a href="{{ route('admin.messages.index') }}" class="text-sm underline">Lihat Inbox</a>
      @endif
    </div>

    <div class="space-y-3">
      @forelse($latestMessages as $m)
        <div class="rounded-xl border p-3 hover:bg-zinc-50 transition">
          <div class="text-sm font-medium truncate">
            {{ $m->name }}
            <span class="text-zinc-500">— {{ $m->email }}</span>
          </div>
          <div class="text-sm text-zinc-700 mt-1 line-clamp-2">{{ $m->message }}</div>

          @if (RouteFacade::has('admin.messages.show'))
            <a href="{{ route('admin.messages.show', $m) }}" class="text-xs text-indigo-600 underline mt-1 inline-block">Lihat detail</a>
          @endif
        </div>
      @empty
        <div class="text-sm text-zinc-500">Belum ada pesan.</div>
        @if (RouteFacade::has('admin.messages.index'))
          <a href="{{ route('admin.messages.index') }}" class="inline-flex items-center gap-1 text-sm underline mt-1">
            Buka Inbox
          </a>
        @endif
      @endforelse
    </div>
  </div>
</section>
@endsection
