{{-- resources/views/backend/experiences/edit.blade.php --}}
@extends('backend.layouts.app')

@section('content')
@php
  $started = old('started_at', optional($experience->started_at)->format('Y-m-d'));
  $ended   = old('ended_at',   optional($experience->ended_at)->format('Y-m-d'));
@endphp

<div class="mx-auto max-w-4xl">
  {{-- Header --}}
  <div class="mb-6 flex items-center justify-between gap-3">
    <div>
      <div class="text-xs text-zinc-500">Dashboard / Experiences / <span class="text-zinc-700">Edit</span></div>
      <h1 class="text-2xl font-semibold mt-1">Edit Riwayat Pekerjaan</h1>
      <p class="text-sm text-zinc-600 mt-1">Perbarui detail pekerjaanmu. Deskripsi mendukung <span class="font-medium">Markdown</span>.</p>
    </div>
    <a href="{{ route('admin.experiences.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2 rounded-xl border hover:bg-zinc-50">
      <svg class="size-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" d="m10 19-7-7 7-7M3 12h18"/>
      </svg>
      Kembali
    </a>
  </div>

  {{-- Alert error --}}
  @if ($errors->any())
    <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3 text-sm">
      <div class="font-medium mb-1">Periksa kembali isianmu:</div>
      <ul class="list-disc list-inside space-y-0.5">
        @foreach ($errors->all() as $e) <li>{{ $e }}</li> @endforeach
      </ul>
    </div>
  @endif

  {{-- Card form --}}
  <form action="{{ route('admin.experiences.update', $experience) }}" method="POST"
        class="rounded-2xl border bg-white/95 backdrop-blur p-5 md:p-6 shadow-sm space-y-6">
    @csrf
    @method('PUT')

    {{-- Row: perusahaan + jabatan --}}
    <div class="grid md:grid-cols-2 gap-4">
      <div>
        <label for="company" class="text-[13px] font-medium text-zinc-800">Perusahaan <span class="text-rose-600">*</span></label>
        <div class="mt-1 relative">
          <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
            <svg class="size-5" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" d="M3 21v-8a2 2 0 0 1 2-2h4m10 10v-8a2 2 0 0 0-2-2h-4M7 7a5 5 0 0 1 10 0v2H7V7Z"/>
            </svg>
          </span>
          <input id="company" name="company"
                 value="{{ old('company', $experience->company) }}" required
                 class="w-full pl-10 pr-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('company') ring-2 ring-rose-500 border-rose-500 @enderror">
        </div>
        @error('company') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
      </div>

      <div>
        <label for="title" class="text-[13px] font-medium text-zinc-800">Jabatan <span class="text-rose-600">*</span></label>
        <div class="mt-1 relative">
          <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
            <svg class="size-5" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" d="M5 8h14M5 12h14M5 16h8"/>
            </svg>
          </span>
          <input id="title" name="title"
                 value="{{ old('title', $experience->title) }}" required
                 class="w-full pl-10 pr-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('title') ring-2 ring-rose-500 border-rose-500 @enderror">
        </div>
        @error('title') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
      </div>
    </div>

    {{-- Row: lokasi + mulai + selesai --}}
    <div class="grid md:grid-cols-3 gap-4">
      <div>
        <label for="location" class="text-[13px] font-medium text-zinc-800">Lokasi (opsional)</label>
        <div class="mt-1 relative">
          <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
            <svg class="size-5" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" d="M12 21s-6-4.5-6-10a6 6 0 1 1 12 0c0 5.5-6 10-6 10Z"/><circle cx="12" cy="11" r="2"/>
            </svg>
          </span>
          <input id="location" name="location"
                 value="{{ old('location', $experience->location) }}"
                 class="w-full pl-10 pr-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('location') ring-2 ring-rose-500 border-rose-500 @enderror">
        </div>
        @error('location') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
      </div>

      <div>
        <label for="started_at" class="text-[13px] font-medium text-zinc-800">Mulai <span class="text-rose-600">*</span></label>
        <input type="date" id="started_at" name="started_at" value="{{ $started }}" required
               class="w-full mt-1 px-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('started_at') ring-2 ring-rose-500 border-rose-500 @enderror">
        @error('started_at') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
      </div>

      <div>
        <label for="ended_at" class="text-[13px] font-medium text-zinc-800">Selesai <span class="text-zinc-400 font-normal">(kosong = masih berjalan)</span></label>
        <input type="date" id="ended_at" name="ended_at" value="{{ $ended }}"
               class="w-full mt-1 px-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('ended_at') ring-2 ring-rose-500 border-rose-500 @enderror">
        @error('ended_at') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
      </div>
    </div>

    {{-- Deskripsi (EasyMDE) --}}
    <div>
      <div class="flex items-center justify-between">
        <label for="description" class="text-[13px] font-medium text-zinc-800">Deskripsi</label>
        <span class="text-[11px] text-zinc-500">Markdown didukung • <code>**bold**</code>, <code>_italic_</code>, list</span>
      </div>
      <textarea
        id="description"
        name="description"
        data-editor="easymde"
        rows="8"
        class="w-full mt-1 px-3 py-2 rounded-xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500 @error('description') ring-2 ring-rose-500 border-rose-500 @enderror"
        placeholder="Tulis deskripsi pekerjaan, tanggung jawab, dan pencapaian…">{{ old('description', $experience->description) }}</textarea>
      @error('description') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror

      <p class="text-xs text-zinc-500 mt-2 flex items-center gap-1">
        <svg class="size-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m2-4h.01M12 18.5a6.5 6.5 0 1 0 0-13 6.5 6.5 0 0 0 0 13Z"/></svg>
        Tips: pisahkan paragraf dengan baris kosong. Gunakan tombol <em>Preview</em> di toolbar.
      </p>
    </div>

    {{-- Status --}}
    <div class="flex items-center justify-between rounded-xl border bg-zinc-50 px-4 py-3">
      <div>
        <div class="text-sm font-medium">Status</div>
        <p class="text-xs text-zinc-600">Kontrol visibilitas di halaman About.</p>
      </div>
      <label class="inline-flex items-center cursor-pointer select-none">
        <input type="hidden" name="is_active" value="0">
        <input type="checkbox" name="is_active" value="1"
               class="h-4 w-4"
               {{ old('is_active', (int) $experience->is_active) ? 'checked' : '' }}>
        <span class="ml-2 text-sm">Active</span>
      </label>
    </div>

    {{-- Action bar (statik, tidak geser) --}}
    <div class="pt-2">
      <div class="flex items-center gap-3 justify-end border-t pt-4">
        <a href="{{ route('admin.experiences.index') }}"
           class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Batal</a>
        <button class="px-5 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 shadow-sm">
          Update
        </button>
      </div>
    </div>
  </form>
</div>
@endsection
