{{-- resources/views/backend/experiences/index.blade.php --}}
@extends('backend.layouts.app')

@section('content')
<div class="max-w-6xl">
  <h1 class="text-2xl font-semibold mb-6">Riwayat Pekerjaan</h1>

  @if (session('status'))
    <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3 text-sm">
      {{ session('status') }}
    </div>
  @endif

  <div class="rounded-2xl border bg-white p-5 shadow-sm">
    <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between">
      <form method="GET" class="flex w-full md:w-auto items-stretch gap-2">
        <input type="text" name="q" value="{{ $q }}"
               placeholder="Cari perusahaan / jabatan…"
               class="flex-1 w-full md:w-80 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
        <button class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Cari</button>
        @if($q)
          <a href="{{ route('admin.experiences.index') }}" class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Reset</a>
        @endif
      </form>

      <a href="{{ route('admin.experiences.create') }}"
         class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700">
        <span class="text-lg">＋</span> Tambah
      </a>
    </div>

    {{-- Desktop --}}
    <div class="hidden md:block mt-4 overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead>
          <tr class="border-b text-zinc-600">
            <th class="py-2 px-3 text-left">Perusahaan</th>
            <th class="py-2 px-3 text-left">Jabatan</th>
            <th class="py-2 px-3 text-left">Periode</th>
            <th class="py-2 px-3 text-left">Status</th>
            <th class="py-2 px-3 text-right">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @forelse ($experiences as $exp)
            <tr class="border-b last:border-0 hover:bg-zinc-50/50">
              <td class="py-2 px-3 align-middle">
                <div class="font-medium">{{ $exp->company }}</div>
                <div class="text-xs text-zinc-500">{{ $exp->location }}</div>
              </td>
              <td class="py-2 px-3 align-middle">{{ $exp->title }}</td>
              <td class="py-2 px-3 align-middle">
                {{ $exp->started_at?->format('Y-m') }} — {{ $exp->ended_at?->format('Y-m') ?? 'Sekarang' }}
              </td>
              <td class="py-2 px-3 align-middle">
                <form action="{{ route('admin.experiences.toggle', $exp) }}" method="POST">
                  @csrf @method('PATCH')
                  @if($exp->is_active)
                    <button class="px-2 py-1 text-xs rounded bg-green-100 text-green-700 hover:bg-green-200">Active</button>
                  @else
                    <button class="px-2 py-1 text-xs rounded bg-rose-100 text-rose-700 hover:bg-rose-200">Inactive</button>
                  @endif
                </form>
              </td>
              <td class="py-2 px-3 align-middle">
                <div class="flex justify-end gap-2">
                  <a href="{{ route('admin.experiences.edit', $exp) }}" class="px-3 py-1.5 rounded-lg border hover:bg-white">Edit</a>
                  <form action="{{ route('admin.experiences.destroy', $exp) }}" method="POST" onsubmit="return confirm('Hapus riwayat ini?')">
                    @csrf @method('DELETE')
                    <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50">Delete</button>
                  </form>
                </div>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="5" class="py-10">
                <div class="text-center text-zinc-600">
                  Belum ada data.
                </div>
              </td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- Mobile --}}
    <div class="md:hidden mt-4 space-y-3">
      @forelse ($experiences as $exp)
        <div class="rounded-xl border p-3">
          <div class="flex items-start justify-between gap-3">
            <div>
              <div class="font-semibold">{{ $exp->company }}</div>
              <div class="text-xs text-zinc-600">{{ $exp->title }} • {{ $exp->location }}</div>
              <div class="text-xs text-zinc-500 mt-0.5">
                {{ $exp->started_at?->format('Y-m') }} — {{ $exp->ended_at?->format('Y-m') ?? 'Sekarang' }}
              </div>
            </div>
            <form action="{{ route('admin.experiences.toggle', $exp) }}" method="POST" class="shrink-0">
              @csrf @method('PATCH')
              @if($exp->is_active)
                <button class="px-2 py-1 text-xs rounded bg-green-100 text-green-700 hover:bg-green-200">Active</button>
              @else
                <button class="px-2 py-1 text-xs rounded bg-rose-100 text-rose-700 hover:bg-rose-200">Inactive</button>
              @endif
            </form>
          </div>
          <div class="mt-3 flex items-center justify-end gap-2">
            <a href="{{ route('admin.experiences.edit', $exp) }}" class="px-3 py-1.5 rounded-lg border hover:bg-white">Edit</a>
            <form action="{{ route('admin.experiences.destroy', $exp) }}" method="POST" onsubmit="return confirm('Hapus riwayat ini?')">
              @csrf @method('DELETE')
              <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50">Delete</button>
            </form>
          </div>
        </div>
      @empty
        <div class="rounded-xl border p-6 text-center text-zinc-600">Belum ada data.</div>
      @endforelse
    </div>

    {{-- Pagination --}}
    @if ($experiences->hasPages())
      <div class="mt-5">{{ $experiences->links() }}</div>
    @endif
  </div>
</div>
@endsection
