<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>{{ $title ?? 'Admin — Ammar Azmi' }}</title>

  {{-- CSRF meta untuk AJAX optional --}}
  <meta name="csrf-token" content="{{ csrf_token() }}">

  {{-- Asset utama via Vite --}}
  @vite(['resources/css/app.css','resources/js/app.js'])

  {{-- Stack untuk CSS pihak ketiga (Leaflet, dll) --}}
  @stack('styles')

  {{-- Sedikit CSS untuk animasi panah dropdown --}}
  <style>
    #user-menu[open] .chev { transform: rotate(180deg); }
  </style>
</head>
<body class="min-h-dvh bg-zinc-50 text-zinc-900 antialiased">
  {{-- Header sticky + z-index tinggi supaya dropdown tidak ketutup --}}
  <header class="sticky top-0 z-[100] border-b bg-white/70 backdrop-blur">
    <nav class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
      <a href="{{ route('admin.dashboard') }}" class="font-semibold">DASHBOARD PROFILE</a>

      {{-- Kanan: Bell + User --}}
      <div class="flex items-center gap-2">
        @php
          // Ambil data untuk bell (server-side, stabil)
          use App\Models\ContactMessage;
          $__unread = ContactMessage::where('status','new')->count();
          $__latest = ContactMessage::latest()->take(5)->get();
        @endphp

        {{-- NOTIF BELL --}}
        <details class="relative" id="inbox-bell">
          <summary class="flex items-center gap-2 px-2.5 py-1.5 rounded-xl border bg-white hover:bg-zinc-50 cursor-pointer list-none select-none">
            <div class="relative">
              {{-- ikon lonceng --}}
              <svg class="w-5 h-5 text-zinc-700" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                <path d="M6 8a6 6 0 1 1 12 0c0 5 2 6 2 8H4c0-2 2-3 2-8Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"/>
                <path d="M9 19a3 3 0 0 0 6 0" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"/>
              </svg>
              {{-- badge count --}}
              @if($__unread > 0)
                <span id="inbox-badge"
                      class="absolute -top-1 -right-1 min-w-[18px] h-[18px] px-1 rounded-full bg-rose-500 text-white text-[11px] leading-[18px] text-center">
                  {{ $__unread > 99 ? '99+' : $__unread }}
                </span>
              @else
                <span id="inbox-badge" class="hidden"></span>
              @endif
            </div>
            <span class="hidden sm:inline text-sm">Inbox</span>
          </summary>

          {{-- dropdown list --}}
          <div class="absolute right-0 mt-2 w-[22rem] rounded-xl border bg-white shadow-xl ring-1 ring-black/5 z-[120] overflow-hidden">
            <div class="px-4 py-3 border-b flex items-center justify-between">
              <div class="font-medium">Pesan Masuk</div>
              <a href="{{ route('admin.messages.index') }}" class="text-xs text-indigo-600 hover:underline">Lihat semua</a>
            </div>

            @if($__latest->count())
              <ul id="inbox-list" class="max-h-80 overflow-auto divide-y">
                @foreach($__latest as $cm)
                  <li class="p-3 hover:bg-zinc-50">
                    <a href="{{ route('admin.messages.show', $cm) }}" class="block">
                      <div class="flex items-center justify-between gap-3">
                        <div class="font-medium truncate">{{ $cm->name }}</div>
                        <span class="text-[11px] text-zinc-500 shrink-0">
                          {{ $cm->created_at?->diffForHumans() }}
                        </span>
                      </div>
                      <div class="text-xs text-zinc-600 truncate">{{ $cm->email }}</div>
                      <p class="text-sm text-zinc-700 line-clamp-2 mt-1">
                        {{ Str::limit(strip_tags($cm->message), 120) }}
                      </p>
                      @if($cm->status === 'new')
                        <span class="mt-2 inline-block px-2 py-0.5 text-[11px] rounded bg-emerald-100 text-emerald-700">Baru</span>
                      @endif
                    </a>
                  </li>
                @endforeach
              </ul>
            @else
              <div id="inbox-empty" class="p-4 text-sm text-zinc-600">Belum ada pesan.</div>
            @endif

            <div class="px-4 py-2 border-t bg-zinc-50">
              <a href="{{ route('admin.messages.index') }}" class="text-sm text-indigo-600 hover:underline">Buka Inbox</a>
            </div>
          </div>
        </details>
        {{-- /NOTIF BELL --}}

        {{-- Burger menu user --}}
        @auth
          <details class="relative" id="user-menu">
            <summary
              class="flex items-center gap-2 px-3 py-1.5 rounded-xl border bg-white hover:bg-zinc-50 cursor-pointer list-none select-none">
              <svg class="w-5 h-5 text-zinc-700" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                <path d="M4 7h16M4 12h16M4 17h16" stroke="currentColor" stroke-width="1.8" stroke-linecap="round"/>
              </svg>
              <span class="hidden sm:inline text-sm max-w-[10rem] truncate">
                {{ auth()->user()->name ?? 'User' }}
              </span>
              <svg class="chev w-4 h-4 text-zinc-500 hidden sm:inline transition-transform" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                <path d="M6 9l6 6 6-6" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
            </summary>

            <div class="absolute right-0 mt-2 w-72 rounded-xl border bg-white shadow-xl ring-1 ring-black/5 z-[120] overflow-hidden">
              <div class="px-4 py-3 border-b">
                <div class="text-xs text-zinc-500">Masuk sebagai</div>
                <div class="font-medium truncate">{{ auth()->user()->name }}</div>
                @if(auth()->user()->email)
                  <div class="text-xs text-zinc-500 truncate">{{ auth()->user()->email }}</div>
                @endif
              </div>

              <div class="p-1">
                <a href="{{ \Illuminate\Support\Facades\Route::has('password.edit') ? route('password.edit') : '#' }}"
                   class="flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-zinc-50">
                  <svg class="w-4 h-4 text-zinc-600" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                    <path d="M7 11V7a5 5 0 1 1 10 0v4" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"/>
                    <rect x="5" y="11" width="14" height="10" rx="2" stroke="currentColor" stroke-width="1.6"/>
                    <circle cx="12" cy="16" r="1" fill="currentColor"/>
                  </svg>
                  <span>Ubah Password</span>
                </a>

                <form action="{{ url('/logout') }}" method="POST">
                  @csrf
                  <button type="submit"
                          class="w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-rose-50 text-rose-600">
                    <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                      <path d="M15 17l5-5-5-5M20 12H9" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
                      <path d="M12 19H7a2 2 0 0 1-2-2V7a2 2 0 0 1 2-2h5" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"/>
                    </svg>
                    <span>Logout</span>
                  </button>
                </form>
              </div>
            </div>
          </details>
        @endauth

        @guest
          <a href="{{ route('login') }}" class="px-3 py-1.5 rounded-xl border hover:bg-zinc-50">Login</a>
        @endguest
      </div>
    </nav>
  </header>

  <main class="max-w-6xl mx-auto px-4 py-8">
    @if (session('success'))
      <div class="mb-6 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-4">
        {{ session('success') }}
      </div>
    @endif

    @yield('content')
  </main>

  <footer class="border-t bg-white/70">
    <div class="max-w-6xl mx-auto px-4 py-6 text-sm text-zinc-600">
      © {{ date('Y') }} Admin — Ammar Azmi
    </div>
  </footer>

  @stack('scripts')

  <script>
    // Tutup details saat klik di luar / tekan ESC
    (function () {
      const menus = [document.getElementById('user-menu'), document.getElementById('inbox-bell')].filter(Boolean);

      document.addEventListener('click', (e) => {
        for (const m of menus) {
          if (m.hasAttribute('open') && !m.contains(e.target)) m.removeAttribute('open');
        }
      });

      document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
          for (const m of menus) if (m?.hasAttribute('open')) m.removeAttribute('open');
        }
      });
    })();

    // OPTIONAL: auto-refresh badge tiap 30 detik (butuh route JSON di bawah)
    (function () {
      const badge = document.getElementById('inbox-badge');
      if (!badge) return;

      async function refreshCount() {
        try {
          const res = await fetch("{{ route('admin.messages.unread-count') }}", {
            headers: { 'X-Requested-With': 'XMLHttpRequest' }
          });
          if (!res.ok) return;
          const data = await res.json();
          const c = Number(data.count || 0);
          if (c > 0) {
            badge.textContent = c > 99 ? '99+' : c;
            badge.classList.remove('hidden');
          } else {
            badge.classList.add('hidden');
          }
        } catch (e) { /* diam */ }
      }
      setInterval(refreshCount, 30000);
    })();
  </script>
</body>
</html>
