{{-- resources/views/backend/messages/index.blade.php --}}
@extends('backend.layouts.app')

@section('content')
<div class="max-w-6xl">
  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
    <div>
      <div class="text-xs text-zinc-500">Dashboard / <span class="text-zinc-700">Inbox</span></div>
      <h1 class="text-2xl font-semibold mt-1">Inbox Pesan</h1>
      <p class="text-sm text-zinc-600">Kelola pesan masuk dari halaman kontak.</p>
    </div>

    {{-- Filter status + search --}}
    <form method="GET" class="flex flex-col sm:flex-row gap-2 sm:items-center">
      <select name="status" class="px-3 py-2 rounded-xl border bg-white">
        <option value="">Semua Status</option>
        <option value="new"      @selected(request('status')==='new')>Baru</option>
        <option value="read"     @selected(request('status')==='read')>Dibaca</option>
        <option value="resolved" @selected(request('status')==='resolved')>Selesai</option>
      </select>
      <input type="text" name="q" value="{{ request('q') }}" placeholder="Cari nama/email/pesan…"
             class="px-3 py-2 rounded-xl border w-full sm:w-64">
      <div class="flex gap-2">
        <button class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Terapkan</button>
        @if(request('q') || request('status'))
          <a href="{{ route('admin.messages.index') }}" class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Reset</a>
        @endif
      </div>
    </form>
  </div>

  @if (session('success'))
    <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3 text-sm">
      {{ session('success') }}
    </div>
  @endif

  {{-- ===== Bulk Bar (sticky) ===== --}}
  <form id="bulkForm" action="{{ route('admin.messages.bulk-destroy') }}" method="POST" class="mb-3">
    @csrf
    <div id="bulkBar" class="hidden rounded-xl border bg-zinc-50 px-3 py-2 text-sm flex items-center justify-between">
      <div>
        <span id="bulkCount" class="font-semibold">0</span> pesan dipilih
      </div>
      <div class="flex flex-wrap gap-2">
        <button type="submit"
                onclick="return confirm('Hapus semua pesan terpilih?')"
                class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50">
          Hapus Terpilih
        </button>
      </div>
    </div>
  </form>

  <div class="rounded-2xl border bg-white p-0 overflow-hidden">
    {{-- Desktop table --}}
    <div class="hidden md:block overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead>
          <tr class="border-b bg-zinc-50 text-zinc-600">
            <th class="py-2 px-3 w-12">
              <input type="checkbox" id="selectAllDesktop" class="h-4 w-4">
            </th>
            <th class="py-2 px-3 text-left w-32">Tanggal</th>
            <th class="py-2 px-3 text-left">Pengirim</th>
            <th class="py-2 px-3 text-left">Email</th>
            <th class="py-2 px-3 text-left w-[45%]">Cuplikan Pesan</th>
            <th class="py-2 px-3 text-left">Status</th>
            <th class="py-2 px-3 text-right w-52">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @forelse ($messages as $m)
            <tr class="border-b last:border-0 hover:bg-zinc-50/50 align-top">
              <td class="py-3 px-3">
                <input type="checkbox" value="{{ $m->id }}" class="rowCheck h-4 w-4" data-row-id="{{ $m->id }}">
              </td>
              <td class="py-3 px-3 whitespace-nowrap text-zinc-600">
                {{ $m->created_at?->format('d M Y H:i') }}
              </td>
              <td class="py-3 px-3">
                <div class="font-medium">{{ $m->name }}</div>
              </td>
              <td class="py-3 px-3">
                <a href="mailto:{{ $m->email }}" class="text-indigo-600 hover:underline">{{ $m->email }}</a>
              </td>
              <td class="py-3 px-3">
                <div class="line-clamp-2 text-zinc-700">
                  {{ Str::limit(strip_tags($m->message), 180) }}
                </div>
              </td>
              <td class="py-3 px-3">
                @php
                  $badge = match($m->status) {
                    'resolved' => 'bg-emerald-100 text-emerald-700',
                    'read'     => 'bg-blue-100 text-blue-700',
                    'new', null => 'bg-amber-100 text-amber-700',
                    default    => 'bg-zinc-100 text-zinc-700',
                  };
                  $label = match($m->status) {
                    'resolved' => 'Selesai',
                    'read'     => 'Dibaca',
                    'new', null => 'Baru',
                    default    => ucfirst($m->status),
                  };
                @endphp
                <span class="px-2 py-1 text-xs rounded {{ $badge }}">{{ $label }}</span>
              </td>
              <td class="py-3 px-3">
                <div class="flex justify-end gap-2">
                  <a href="{{ route('admin.messages.show', $m) }}" class="px-3 py-1.5 rounded-lg border hover:bg-white">Detail</a>

                  {{-- Dropdown tindakan cepat (ubah status) --}}
                  <details class="relative">
                    <summary class="px-3 py-1.5 rounded-lg border hover:bg-white cursor-pointer list-none select-none">
                      Ubah Status
                    </summary>
                    <div class="absolute right-0 mt-1 w-44 rounded-xl border bg-white shadow-md p-1 z-10">
                      <form action="{{ route('admin.messages.update', $m) }}" method="POST">
                        @csrf @method('PATCH')
                        <input type="hidden" name="status" value="new">
                        <button class="w-full text-left px-3 py-1.5 rounded-lg hover:bg-zinc-50">Tandai Baru</button>
                      </form>
                      <form action="{{ route('admin.messages.update', $m) }}" method="POST">
                        @csrf @method('PATCH')
                        <input type="hidden" name="status" value="read">
                        <button class="w-full text-left px-3 py-1.5 rounded-lg hover:bg-zinc-50">Tandai Dibaca</button>
                      </form>
                      <form action="{{ route('admin.messages.update', $m) }}" method="POST">
                        @csrf @method('PATCH')
                        <input type="hidden" name="status" value="resolved">
                        <button class="w-full text-left px-3 py-1.5 rounded-lg hover:bg-zinc-50 text-emerald-700">Tandai Selesai</button>
                      </form>
                    </div>
                  </details>

                  {{-- Hapus satuan --}}
                  <form action="{{ route('admin.messages.destroy', $m) }}" method="POST"
                        onsubmit="return confirm('Hapus pesan ini?')">
                    @csrf @method('DELETE')
                    <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50">Hapus</button>
                  </form>
                </div>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="7" class="py-14 text-center text-zinc-600">
                <div class="text-3xl mb-1">📭</div>
                Belum ada pesan.
              </td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- Mobile list --}}
    <div class="md:hidden divide-y">
      @forelse ($messages as $m)
        <div class="p-4">
          <div class="flex items-start justify-between gap-3">
            <div class="flex items-start gap-2">
              <input type="checkbox" value="{{ $m->id }}" class="rowCheck h-4 w-4 mt-1.5" data-row-id="{{ $m->id }}">
              <div>
                <div class="font-semibold">{{ $m->name }}</div>
                <a href="mailto:{{ $m->email }}" class="text-xs text-indigo-600 hover:underline">{{ $m->email }}</a>
                <div class="text-xs text-zinc-500 mt-1">{{ $m->created_at?->format('d M Y H:i') }}</div>
              </div>
            </div>
            @php
              $badge = match($m->status) {
                'resolved' => 'bg-emerald-100 text-emerald-700',
                'read'     => 'bg-blue-100 text-blue-700',
                'new', null => 'bg-amber-100 text-amber-700',
                default    => 'bg-zinc-100 text-zinc-700',
              };
              $label = match($m->status) {
                'resolved' => 'Selesai',
                'read'     => 'Dibaca',
                'new', null => 'Baru',
                default    => ucfirst($m->status),
              };
            @endphp
            <span class="px-2 py-1 text-xs rounded {{ $badge }}">{{ $label }}</span>
          </div>

          <p class="text-sm text-zinc-700 mt-2 line-clamp-3">{{ Str::limit(strip_tags($m->message), 200) }}</p>

          <div class="mt-3 flex items-center justify-between">
            <a href="{{ route('admin.messages.show', $m) }}" class="px-3 py-1.5 rounded-lg border hover:bg-white">Detail</a>

            <div class="flex gap-2">
              <form action="{{ route('admin.messages.update', $m) }}" method="POST">
                @csrf @method('PATCH')
                <input type="hidden" name="status" value="read">
                <button class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs">Dibaca</button>
              </form>
              <form action="{{ route('admin.messages.update', $m) }}" method="POST">
                @csrf @method('PATCH')
                <input type="hidden" name="status" value="resolved">
                <button class="px-3 py-1.5 rounded-lg border hover:bg-white text-xs text-emerald-700">Selesai</button>
              </form>

              {{-- Hapus satuan (mobile) --}}
              <form action="{{ route('admin.messages.destroy', $m) }}" method="POST"
                    onsubmit="return confirm('Hapus pesan ini?')">
                @csrf @method('DELETE')
                <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50 text-xs">Hapus</button>
              </form>
            </div>
          </div>
        </div>
      @empty
        <div class="p-10 text-center text-zinc-600">
          <div class="text-3xl mb-1">📭</div>
          Belum ada pesan.
        </div>
      @endforelse
    </div>
  </div>

  {{-- Pagination --}}
  @if ($messages instanceof \Illuminate\Contracts\Pagination\Paginator && $messages->hasPages())
    <div class="mt-5">
      {{ $messages->withQueryString()->links() }}
    </div>
  @endif
</div>
@endsection

@push('scripts')
<script>
(function(){
  const bulkForm = document.getElementById('bulkForm');
  const bulkBar  = document.getElementById('bulkBar');
  const bulkCount= document.getElementById('bulkCount');
  const selectAllDesktop = document.getElementById('selectAllDesktop');

  const rowChecks = () => Array.from(document.querySelectorAll('.rowCheck'));

  // Select all (desktop)
  selectAllDesktop?.addEventListener('change', (e)=>{
    rowChecks().forEach(c => c.checked = e.target.checked);
    refreshBulk();
  });

  // Per-row change
  document.addEventListener('change', (e)=>{
    if (e.target.classList.contains('rowCheck')) refreshBulk();
  });

  function refreshBulk(){
    const checks   = rowChecks();
    const selected = checks.filter(c => c.checked);
    const total    = checks.length;

    // sync select all state
    if (selectAllDesktop) {
      selectAllDesktop.checked = total>0 && selected.length === total;
      selectAllDesktop.indeterminate = selected.length>0 && selected.length<total;
    }

    // toggle bulk bar
    if (selected.length > 0) {
      bulkBar.classList.remove('hidden');
      bulkCount.textContent = selected.length;

      // bersihkan input ids[] lama
      bulkForm.querySelectorAll('input[name="ids[]"]').forEach(el => el.remove());
      // tambahkan ids baru
      selected.forEach(c => {
        const hid = document.createElement('input');
        hid.type = 'hidden';
        hid.name = 'ids[]';
        hid.value = c.value;
        bulkForm.appendChild(hid);
      });
    } else {
      bulkBar.classList.add('hidden');
      bulkCount.textContent = 0;
      bulkForm.querySelectorAll('input[name="ids[]"]').forEach(el => el.remove());
    }
  }

  // initial
  refreshBulk();
})();
</script>
@endpush
