{{-- resources/views/backend/messages/show.blade.php --}}
@extends('backend.layouts.app')

@section('content')
<div class="max-w-3xl mx-auto">
  <div class="mb-6 flex items-center justify-between gap-3">
    <div>
      <div class="text-xs text-zinc-500">
        Dashboard / Inbox / <span class="text-zinc-700">Detail</span>
      </div>
      <h1 class="text-2xl font-semibold mt-1">Detail Pesan</h1>
    </div>
    <a href="{{ route('admin.messages.index') }}" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl border hover:bg-zinc-50">
      ← Kembali
    </a>
  </div>

  @if (session('success'))
    <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3 text-sm">
      {{ session('success') }}
    </div>
  @endif

  <div class="rounded-2xl border bg-white p-5 shadow-sm space-y-5">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
      <div class="space-y-0.5">
        <div class="text-sm text-zinc-600">Dari</div>
        <div class="font-medium">{{ $cm->name }}</div>
        <a href="mailto:{{ $cm->email }}" class="text-sm text-indigo-600 hover:underline break-all">
          {{ $cm->email }}
        </a>
      </div>
      <div class="text-sm text-zinc-600">
        {{ $cm->created_at?->format('d M Y H:i') }}
      </div>
    </div>

    <div class="rounded-xl border bg-zinc-50 p-4">
      <div class="text-sm text-zinc-600 mb-1">Pesan</div>
      {{-- konten pesan dibatasi tinggi, bisa scroll --}}
      <div class="max-h-72 overflow-auto prose prose-zinc prose-sm">
        {!! nl2br(e($cm->message)) !!}
      </div>
    </div>

    {{-- Info penanganan (opsional) --}}
    <div class="grid sm:grid-cols-2 gap-4">
      <div class="rounded-xl border bg-white p-4">
        <div class="text-sm text-zinc-600">Status</div>
        @php
          $badge = match($cm->status) {
            'resolved' => 'bg-emerald-100 text-emerald-700',
            'read'     => 'bg-blue-100 text-blue-700',
            'new', null => 'bg-amber-100 text-amber-700',
            default    => 'bg-zinc-100 text-zinc-700',
          };
          $label = match($cm->status) {
            'resolved' => 'Selesai',
            'read'     => 'Dibaca',
            'new', null => 'Baru',
            default    => ucfirst($cm->status),
          };
        @endphp
        <div class="mt-1"><span class="px-2 py-1 text-xs rounded {{ $badge }}">{{ $label }}</span></div>
      </div>

      <div class="rounded-xl border bg-white p-4">
        <div class="text-sm text-zinc-600">Ditangani</div>
        <div class="mt-1 text-sm">
          @if ($cm->handled_by)
            <div>Oleh: <span class="font-medium">{{ $cm->handled_by }}</span></div>
            <div>Waktu: {{ $cm->handled_at?->format('d M Y H:i') ?? '-' }}</div>
          @else
            <span class="text-zinc-500">Belum ada</span>
          @endif
        </div>
      </div>
    </div>

    {{-- Aksi cepat ubah status --}}
    <div class="flex flex-wrap gap-2 pt-2">
      <form action="{{ route('admin.messages.update', $cm) }}" method="POST">
        @csrf @method('PATCH')
        <input type="hidden" name="status" value="new">
        <button class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Tandai Baru</button>
      </form>
      <form action="{{ route('admin.messages.update', $cm) }}" method="POST">
        @csrf @method('PATCH')
        <input type="hidden" name="status" value="read">
        <button class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Tandai Dibaca</button>
      </form>
      <form action="{{ route('admin.messages.update', $cm) }}" method="POST">
        @csrf @method('PATCH')
        <input type="hidden" name="status" value="resolved">
        <button class="px-4 py-2 rounded-xl border text-emerald-700 hover:bg-emerald-50">Tandai Selesai</button>
      </form>
    </div>
  </div>
</div>
@endsection
