@extends('backend.layouts.app')

@section('content')
    @php
        use Illuminate\Support\Facades\Storage;

        // Avatar (fallback pravatar)
        $avatarUrl = $profile->avatar_path
            ? Storage::url($profile->avatar_path)
            : 'https://i.pravatar.cc/240?u=' . ($profile->id ?? 'guest');

        $avaName = $profile->avatar_path ? basename($profile->avatar_path) : null;

        // Koordinat default (Jakarta) bila kosong
        $defaultLat = (float) old('lat', $profile->lat ?? -6.2);
        $defaultLng = (float) old('lng', $profile->lng ?? 106.816666);
    @endphp

    <h1 class="text-2xl font-semibold mb-6">Edit Profil</h1>

    @if (session('status'))
        <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3 text-sm">
            {{ session('status') }}
        </div>
    @endif

    <form action="{{ route('admin.profile.update') }}" method="POST" enctype="multipart/form-data"
        class="grid lg:grid-cols-3 gap-6">
        @csrf
        @method('PUT')

        {{-- KOLOM KIRI --}}
        <section class="lg:col-span-1 space-y-6">
            {{-- Avatar --}}
            <div class="rounded-2xl border bg-white p-5 hover:shadow-md transition">
                <h2 class="font-semibold mb-3">Avatar</h2>

                <div class="relative group w-40 h-40">
                    <img src="{{ $avatarUrl }}" alt="avatar" loading="lazy"
                        class="w-40 h-40 object-cover rounded-2xl border transition duration-200 group-hover:scale-105" />
                    <div
                        class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 flex items-center justify-center rounded-2xl transition">
                        <span class="text-white text-xs font-medium">Preview Avatar</span>
                    </div>
                </div>

                @if ($avaName)
                    <p class="text-xs text-zinc-600 mt-2">File saat ini: <span
                            class="font-medium">{{ $avaName }}</span></p>
                @endif

                <div class="mt-3 space-y-2">
                    <label class="text-sm block">Unggah Avatar Baru</label>
                    <input type="file" name="avatar" accept="image/*"
                        class="block w-full text-sm file:rounded-lg file:border file:px-3 file:py-1 file:bg-zinc-100 file:hover:bg-zinc-200 cursor-pointer">
                    @error('avatar')
                        <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                    @enderror

                    @if ($profile->avatar_path)
                        <button type="submit" form="delete-avatar-form"
                            class="text-sm underline text-rose-600 hover:text-rose-800">
                            Hapus avatar
                        </button>
                    @endif
                </div>
            </div>
        </section>

        {{-- KOLOM KANAN --}}
        <section class="lg:col-span-2 space-y-6">
            {{-- Informasi utama --}}
            <div class="rounded-2xl border bg-white p-5 hover:shadow-md transition">
                <h2 class="font-semibold mb-4">Informasi Utama</h2>

                <div class="grid sm:grid-cols-2 gap-4">

                    {{-- NAMA --}}
                    <div>
                        <label class="text-sm">Nama</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- user icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M15.5 8.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0Z" stroke="currentColor"
                                        stroke-width="1.5" />
                                    <path d="M4 19.25a7.5 7.5 0 0 1 16 0" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" />
                                </svg>
                            </span>
                            <input name="name" value="{{ old('name', $profile->name) }}" required
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('name') ring-2 ring-rose-500 border-rose-500 @enderror">
                        </div>
                        @error('name')
                            <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- HEADLINE --}}
                    <div>
                        <label class="text-sm">Headline</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- sparkles icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M12 3l1.6 3.7L17 8.3l-3.4 1.6L12 13l-1.6-3.1L7 8.3l3.4-1.6L12 3Z"
                                        stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
                                    <path d="M18.5 14.5l.7 1.6 1.6 .7-1.6 .7-.7 1.6-.7-1.6-1.6-.7 1.6-.7 .7-1.6Z"
                                        fill="currentColor" />
                                </svg>
                            </span>
                            <input name="headline" value="{{ old('headline', $profile->headline) }}"
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('headline') ring-2 ring-rose-500 border-rose-500 @enderror">
                        </div>
                        @error('headline')
                            <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- EMAIL --}}
                    <div>
                        <label class="text-sm">Email</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- envelope icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M4 7.5a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-9Z"
                                        stroke="currentColor" stroke-width="1.5" />
                                    <path d="M5 8l7 5 7-5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </span>
                            <input name="email" type="email" value="{{ old('email', $profile->email) }}"
                                placeholder="kamu@contoh.com"
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('email') ring-2 ring-rose-500 border-rose-500 @enderror">
                        </div>
                        @error('email')
                            <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <label class="text-sm">Telepon</label>

                        <div
                            class="mt-1 flex items-stretch rounded-xl border bg-white focus-within:ring-2 focus-within:ring-indigo-500">
                            {{-- Prefix negara --}}
                            <div class="flex items-center gap-2 pl-3 pr-2 border-r">
                                {{-- Bendera Indonesia (SVG) --}}
                                <span class="inline-flex w-5 h-3.5 overflow-hidden rounded-sm ring-1 ring-zinc-200">
                                    <svg viewBox="0 0 3 2" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                        <rect width="3" height="1" y="0" fill="#e31d1c" />
                                        <rect width="3" height="1" y="1" fill="#ffffff" />
                                    </svg>
                                </span>
                                <span class="text-sm font-medium select-none">+62</span>
                            </div>

                            {{-- Input telepon --}}
                            <input id="phone" name="phone" inputmode="tel" autocomplete="tel"
                                placeholder="8xx-xxxx-xxxx" value="{{ old('phone', $profile->phone) }}"
                                class="flex-1 px-3 py-2 rounded-r-xl outline-none border-0 focus:ring-0" />
                        </div>

                        <p class="mt-1 text-xs text-zinc-500">Otomatis diformat: +62 8xx-xxxx-xxxx (disimpan sebagai E.164)
                        </p>

                        @error('phone')
                            <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                        @enderror
                    </div>


                    {{-- LOKASI (input atas peta) --}}
                    <div class="sm:col-span-2">
                        <label class="text-sm">Lokasi (alamat/penanda)</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- map pin icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M12 21s7-5.5 7-11a7 7 0 1 0-14 0c0 5.5 7 11 7 11Z" stroke="currentColor"
                                        stroke-width="1.5" />
                                    <circle cx="12" cy="10" r="2.5" stroke="currentColor"
                                        stroke-width="1.5" />
                                </svg>
                            </span>
                            <input id="location_name" name="location" value="{{ old('location', $profile->location) }}"
                                placeholder="Cari alamat atau klik peta"
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('location') ring-2 ring-rose-500 border-rose-500 @enderror">
                        </div>
                        @error('location')
                            <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                        @enderror

                        {{-- hidden lat/lng & peta tetap seperti punyamu --}}
                        <input type="hidden" id="lat" name="lat" value="{{ $defaultLat }}">
                        <input type="hidden" id="lng" name="lng" value="{{ $defaultLng }}">
                        <div id="map" class="mt-3 h-64 rounded-xl border overflow-hidden"></div>
                        <p class="text-xs text-zinc-500 mt-2">Klik/drag penanda atau gunakan pencarian. Alamat & koordinat
                            otomatis terisi.</p>
                    </div>
                </div>
            </div>

            {{-- Tentang --}}
            <div class="rounded-2xl border bg-white p-5 hover:shadow-md transition">
                <div class="flex items-center justify-between mb-3">
                    <h2 class="font-semibold">Tentang</h2>
                    <span class="text-xs text-zinc-500">Gunakan “Ringkas” untuk tagline singkat; “Detail” untuk cerita
                        lengkap.</span>
                </div>

                {{-- RINGKAS --}}
                <label for="about_short" class="text-sm">Ringkas</label>
                <div class="mt-1 relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                        {{-- icon feather-edit --}}
                        <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                            <path d="M12 20h9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                            <path d="M16.5 3.5a2.121 2.121 0 1 1 3 3L8 18l-4 1 1-4 11.5-11.5Z" stroke="currentColor"
                                stroke-width="1.5" stroke-linejoin="round" />
                        </svg>
                    </span>
                    <textarea id="about_short" name="about_short" rows="2" maxlength="200"
                        class="about-autosize w-full pl-10 pr-12 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('about_short') ring-2 ring-rose-500 border-rose-500 @enderror"
                        placeholder="Contoh: Backend engineer yang suka mengulik performa & DX.">{{ old('about_short', $profile->about_short) }}</textarea>

                    {{-- counter --}}
                    <span id="about_short_counter" class="absolute right-3 bottom-2 text-xs text-zinc-500">0/200</span>
                </div>
                @error('about_short')
                    <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                @enderror

                {{-- DETAIL --}}
                <label for="about_long" class="text-sm mt-4 block">Detail</label>
                <div class="mt-1 relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                        {{-- icon file-text --}}
                        <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                            <path d="M14 2H7a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7l-5-5Z" stroke="currentColor"
                                stroke-width="1.5" />
                            <path d="M14 2v5h5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                            <path d="M9 13h6M9 17h6M9 9h3" stroke="currentColor" stroke-width="1.5"
                                stroke-linecap="round" />
                        </svg>
                    </span>

                    <textarea id="about_long" name="about_long" rows="6" data-max="2000"
                        class="about-autosize w-full pl-10 pr-24 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('about_long') ring-2 ring-rose-500 border-rose-500 @enderror"
                        placeholder="Ceritakan pengalaman, minat, dan nilai yang kamu pegang.">{{ old('about_long', $profile->about_long) }}</textarea>

                    {{-- counter & preview toggle --}}
                    <div class="absolute right-3 bottom-2 flex items-center gap-3">
                        <button type="button" id="about_long_preview_btn"
                            class="text-xs px-2 py-1 rounded-lg border hover:bg-zinc-50">Preview</button>
                        <span id="about_long_counter" class="text-xs text-zinc-500">0/2000</span>
                    </div>
                </div>
                @error('about_long')
                    <div class="text-rose-600 text-sm mt-1">{{ $message }}</div>
                @enderror

                {{-- PREVIEW AREA (hidden) --}}
                <div id="about_long_preview"
                    class="mt-3 hidden rounded-xl border bg-zinc-50 p-3 text-sm text-zinc-800 whitespace-pre-line"></div>
            </div>


            {{-- Sosial --}}
            <div class="rounded-2xl border bg-white p-5 hover:shadow-md transition">
                <h2 class="font-semibold mb-3">Sosial</h2>
                <div class="grid sm:grid-cols-3 gap-4">
                    <div>
                        <label class="text-sm">GitHub</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- code icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M8 9l-4 3 4 3M16 9l4 3-4 3" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" />
                                    <path d="M13 5l-2 14" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" />
                                </svg>
                            </span>
                            <input name="github" type="url" placeholder="https://github.com/username"
                                value="{{ old('github', $profile->github) }}"
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                    </div>

                    <div>
                        <label class="text-sm">LinkedIn</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- link icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M10.5 13.5l3-3M7 7h3a4 4 0 0 1 0 8H9M15 9h-3a4 4 0 0 0 0 8h1"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                </svg>
                            </span>
                            <input name="linkedin" type="url" placeholder="https://www.linkedin.com/in/username"
                                value="{{ old('linkedin', $profile->linkedin) }}"
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                    </div>

                    <div>
                        <label class="text-sm">X/Twitter</label>
                        <div class="mt-1 relative">
                            <span
                                class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                                {{-- at icon --}}
                                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none">
                                    <path d="M12 20a8 8 0 1 1 8-8v3a3 3 0 0 1-6 0V9" stroke="currentColor"
                                        stroke-width="1.5" stroke-linecap="round" />
                                    <circle cx="12" cy="12" r="2" stroke="currentColor"
                                        stroke-width="1.5" />
                                </svg>
                            </span>
                            <input name="x" type="url" placeholder="https://x.com/username"
                                value="{{ old('x', $profile->x) }}"
                                class="w-full pl-10 pr-3 py-2 rounded-xl border bg-white shadow-sm transition focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center gap-3">
                <button
                    class="px-5 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 transition">Simpan</button>
                <a href="{{ route('admin.dashboard') }}"
                    class="px-5 py-2 rounded-xl border hover:bg-zinc-50 transition">Batal</a>
            </div>
        </section>
    </form>

    {{-- Form delete avatar (tidak nested) --}}
    @if ($profile->avatar_path)
        <form id="delete-avatar-form" action="{{ route('admin.profile.avatar.destroy') }}" method="POST"
            class="hidden">
            @csrf
            @method('DELETE')
        </form>
    @endif
@endsection

@push('styles')
    {{-- Leaflet + Geocoder CSS --}}
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
        integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />
@endpush

@push('styles')
    {{-- WAJIB (kalau belum): CSS plugin geocoder --}}
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />
@endpush

@push('scripts')
    {{-- Leaflet core + plugin geocoder --}}
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"
        integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>

    <script>
        (function() {
            const latInput = document.getElementById('lat');
            const lngInput = document.getElementById('lng');
            const locInput = document.getElementById('location_name');

            const startLat = parseFloat(latInput.value) || -6.200000;
            const startLng = parseFloat(lngInput.value) || 106.816666;

            const map = L.map('map', {
                scrollWheelZoom: true
            }).setView([startLat, startLng], 13);
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '&copy; OpenStreetMap contributors'
            }).addTo(map);

            const marker = L.marker([startLat, startLng], {
                draggable: true
            }).addTo(map);

            /** Utils **/
            function writeCoords(latlng) {
                latInput.value = latlng.lat.toFixed(6);
                lngInput.value = latlng.lng.toFixed(6);
            }

            function formatStreetCityFromAddr(addr) {
                const street =
                    addr.road || addr.pedestrian || addr.footway || addr.path ||
                    addr.cycleway || addr.residential || addr.street || addr.street_name;
                const house = addr.house_number ? (' ' + addr.house_number) : '';
                const city =
                    addr.city || addr.town || addr.village || addr.suburb ||
                    addr.neighbourhood || addr.district || addr.city_district || addr.county || addr.regency || addr
                    .municipality;
                let label = '';
                if (street) label = `${street}${house}`;
                if (city) label = label ? `${label}, ${city}` : city;
                return label;
            }

            // Race guard untuk beberapa reverse beruntun
            let lastReverseId = 0;
            async function reverseToStreetCity(latlng) {
                const myId = ++lastReverseId;
                locInput.placeholder = 'Mencari alamat…';
                writeCoords(latlng); // koordinat tetap sinkron

                try {
                    const url =
                        `https://nominatim.openstreetmap.org/reverse?format=jsonv2&lat=${latlng.lat}&lon=${latlng.lng}&zoom=18&addressdetails=1&accept-language=id`;
                    const res = await fetch(url, {
                        headers: {
                            'Accept': 'application/json'
                        }
                    });
                    if (!res.ok) throw new Error('reverse geocode fail');
                    const data = await res.json();
                    if (myId !== lastReverseId) return; // ada request yang lebih baru

                    const addr = data.address || {};
                    let label = formatStreetCityFromAddr(addr);
                    if (!label) {
                        if (data.name) label = data.name.split(',')[0].trim();
                        else if (data.display_name) label = data.display_name.split(',')[0].trim();
                    }
                    if (label) locInput.value = label;
                } finally {
                    locInput.placeholder = '';
                }
            }

            /** Interaksi peta **/
            map.on('click', (e) => {
                marker.setLatLng(e.latlng);
                reverseToStreetCity(e.latlng);
            });
            marker.on('dragend', () => {
                const ll = marker.getLatLng();
                reverseToStreetCity(ll);
            });

            /** Kotak pencarian di peta (balik lagi) **/
            const mapGeocoder = L.Control.geocoder({
                    defaultMarkGeocode: false,
                    geocoder: L.Control.Geocoder.nominatim({
                        geocodingQueryParams: {
                            addressdetails: 1,
                            'accept-language': 'id'
                        }
                    })
                })
                .on('markgeocode', function(e) {
                    const c = e.geocode.center;
                    marker.setLatLng(c);
                    writeCoords(c);

                    // Coba pakai alamat dari hasil forward; kalau kurang, reverse agar dapat nama jalan akurat
                    const addr = (e.geocode && e.geocode.properties && e.geocode.properties.address) || {};
                    const label = formatStreetCityFromAddr(addr);
                    if (label) {
                        locInput.value = label;
                    } else {
                        reverseToStreetCity(c);
                    }
                    map.setView(c, 16);
                })
                .addTo(map);

            /** Geocode dari input Lokasi manual (opsional) **/
            async function runForwardGeocode(query) {
                if (!query) return;
                const url =
                    `https://nominatim.openstreetmap.org/search?format=jsonv2&q=${encodeURIComponent(query)}&limit=1&addressdetails=1&accept-language=id`;
                const res = await fetch(url, {
                    headers: {
                        'Accept': 'application/json'
                    }
                });
                if (!res.ok) return;
                const results = await res.json();
                if (!results || !results.length) return;

                const r = results[0];
                const c = {
                    lat: parseFloat(r.lat),
                    lng: parseFloat(r.lon)
                };
                marker.setLatLng(c);
                writeCoords(c);

                const label = formatStreetCityFromAddr(r.address || {});
                if (label) locInput.value = label;
                else reverseToStreetCity(c);
                map.setView(c, 16);
            }

            locInput.addEventListener('keydown', (e) => {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    runForwardGeocode(locInput.value.trim());
                }
            });
            locInput.addEventListener('blur', () => {
                const q = locInput.value.trim();
                if (q) runForwardGeocode(q);
            });
        })();
    </script>
@endpush

@push('scripts')
    <script>
        (function() {
            const input = document.getElementById('phone');
            if (!input) return;

            const onlyDigits = (s) => (s || '').replace(/\D+/g, '');

            // Ambil digit lokal (tanpa 0/62 di depan)
            function localDigits(s) {
                let d = onlyDigits(s);
                if (d.startsWith('62')) d = d.slice(2);
                if (d.startsWith('0')) d = d.slice(1);
                return d;
            }

            // Tampilkan sebagai +62 8xx-xxxx-xxxx (bertahap sesuai panjang)
            function formatDisplay(s) {
                let d = localDigits(s);
                if (!d) return '';
                const parts = [];
                if (d.length <= 3) {
                    parts.push(d);
                } else if (d.length <= 7) {
                    parts.push(d.slice(0, 3), d.slice(3));
                } else if (d.length <= 11) {
                    parts.push(d.slice(0, 3), d.slice(3, 7), d.slice(7));
                } else {
                    parts.push(d.slice(0, 3), d.slice(3, 7), d.slice(7, 11), d.slice(11));
                }
                return '+62 ' + parts.join('-');
            }

            // Nilai final saat submit: +62XXXXXXXXXXX (E.164)
            function toE164(s) {
                const d = localDigits(s);
                return d ? ('+62' + d) : '';
            }

            function refresh() {
                const caretToEnd = document.activeElement === input;
                const formatted = formatDisplay(input.value);
                input.value = formatted;
                if (caretToEnd) input.selectionStart = input.selectionEnd = input.value.length;
            }

            // Format saat halaman dibuka & saat user mengetik
            document.addEventListener('DOMContentLoaded', refresh);
            input.addEventListener('input', refresh);
            input.addEventListener('blur', refresh);

            // Saat submit form, kirim dalam format E.164 ke field yang sama
            const form = input.closest('form');
            if (form) {
                form.addEventListener('submit', () => {
                    input.value = toE164(input.value);
                });
            }
        })();
    </script>
@endpush

@push('scripts')
<script>
(function(){
  // --- autosize ---
  function autoSize(el){
    el.style.height = 'auto';
    el.style.height = (el.scrollHeight) + 'px';
  }
  function bindAutosize(el){
    autoSize(el);
    el.addEventListener('input', ()=>autoSize(el));
  }

  // --- counter ---
  function bindCounter(textarea, counterEl, maxAttr = 'maxlength'){
    const max = parseInt(textarea.getAttribute(maxAttr) || textarea.dataset.max || 0, 10);
    if (!counterEl) return;
    const update = ()=>{
      const len = textarea.value.length;
      counterEl.textContent = max ? `${len}/${max}` : `${len}`;
      // warn if near limit
      counterEl.classList.toggle('text-amber-600', max && len > max*0.9);
      counterEl.classList.toggle('text-rose-600',  max && len > max);
    };
    textarea.addEventListener('input', update);
    update();
  }

  // --- preview toggle for about_long ---
  const longTA   = document.getElementById('about_long');
  const longPrev = document.getElementById('about_long_preview');
  const longBtn  = document.getElementById('about_long_preview_btn');

  document.querySelectorAll('.about-autosize').forEach(bindAutosize);

  bindCounter(document.getElementById('about_short'), document.getElementById('about_short_counter'));      // maxlength=200
  bindCounter(longTA, document.getElementById('about_long_counter'), 'data-max');                            // soft 2000

  if (longBtn && longTA && longPrev){
    longBtn.addEventListener('click', ()=>{
      const open = longPrev.classList.toggle('hidden') === false;
      longPrev.textContent = longTA.value || '—';
      longBtn.classList.toggle('bg-zinc-100', open);
      longBtn.textContent = open ? 'Sembunyikan' : 'Preview';
    });
    // keep preview synced
    longTA.addEventListener('input', ()=>{
      if (!longPrev.classList.contains('hidden')) longPrev.textContent = longTA.value || '—';
    });
  }
})();
</script>
@endpush

