@extends('backend.layouts.app')

@section('content')
@php
  $isEdit = $profile->exists;
  $avatarUrl = $profile->avatar_path ? asset('storage/'.$profile->avatar_path) : 'https://i.pravatar.cc/240?u=ammar';
@endphp

<div class="flex items-center justify-between mb-6">
  <h1 class="text-2xl font-semibold">{{ $isEdit ? 'Edit Profil' : 'Buat Profil' }}</h1>
  <a href="{{ route('admin.profiles.index') }}" class="px-3 py-1.5 rounded border">Kembali</a>
</div>

@if ($errors->any())
  <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3">{{ $errors->first() }}</div>
@endif

<form action="{{ $isEdit ? route('admin.profiles.update',$profile) : route('admin.profiles.store') }}" method="POST" enctype="multipart/form-data" class="grid lg:grid-cols-3 gap-6">
  @csrf
  @if($isEdit) @method('PUT') @endif

  {{-- MEDIA --}}
  <section id="media" class="lg:col-span-1 space-y-6">
    <div class="rounded-2xl border bg-white p-5">
      <h2 class="font-semibold mb-3">Avatar</h2>
      <img src="{{ $avatarUrl }}" class="w-40 h-40 object-cover rounded-2xl border" alt="avatar">
      <div class="mt-3">
        <input type="file" name="avatar" accept="image/*" class="block w-full text-sm">
        <p class="text-xs text-zinc-500 mt-1">JPG/PNG/WEBP maks 2MB.</p>
      </div>
    </div>

    <div class="rounded-2xl border bg-white p-5">
      <h2 class="font-semibold mb-3">CV (PDF)</h2>
      @if($profile->cv_path)
        <a href="{{ asset('storage/'.$profile->cv_path) }}" target="_blank" class="text-sm underline">Lihat CV saat ini</a>
      @else
        <div class="text-sm text-zinc-500">Belum ada CV.</div>
      @endif
      <div class="mt-3">
        <input type="file" name="cv" accept="application/pdf" class="block w-full text-sm">
        <p class="text-xs text-zinc-500 mt-1">PDF maks 4MB.</p>
      </div>
    </div>

    <div class="rounded-2xl border bg-white p-5">
      <h2 class="font-semibold mb-3">Status</h2>
      <label class="flex items-center gap-2 text-sm">
        <input type="checkbox" name="is_public" value="1" {{ old('is_public',$profile->is_public) ? 'checked' : '' }}>
        Public (tampil di situs jika profil ini dipakai)
      </label>
      <label class="flex items-center gap-2 text-sm mt-2">
        <input type="checkbox" name="make_active" value="1">
        Jadikan profil ini **AKTIF** (pakai data) setelah disimpan
      </label>

      <label class="block text-sm mt-4">Tema</label>
      <select name="theme" class="mt-1 w-full px-3 py-2 border rounded">
        @foreach (['system'=>'System','light'=>'Light','dark'=>'Dark'] as $k=>$v)
          <option value="{{ $k }}" @selected(old('theme',$profile->theme)==$k)>{{ $v }}</option>
        @endforeach
      </select>
    </div>
  </section>

  {{-- FORM DETAIL --}}
  <section class="lg:col-span-2 space-y-6">
    <div id="basic" class="rounded-2xl border bg-white p-5">
      <h2 class="font-semibold mb-4">Identitas & Kontak</h2>
      <div class="grid sm:grid-cols-2 gap-4">
        <div><label class="text-sm">Nama</label>
          <input name="name" value="{{ old('name',$profile->name) }}" required class="mt-1 w-full px-3 py-2 border rounded"></div>
        <div><label class="text-sm">Headline</label>
          <input name="headline" value="{{ old('headline',$profile->headline) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
        <div><label class="text-sm">Email</label>
          <input name="email" type="email" value="{{ old('email',$profile->email) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
        <div><label class="text-sm">Telepon</label>
          <input name="phone" value="{{ old('phone',$profile->phone) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
        <div class="sm:col-span-2"><label class="text-sm">Lokasi</label>
          <input name="location" value="{{ old('location',$profile->location) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
      </div>
    </div>

    <div id="about" class="rounded-2xl border bg-white p-5">
      <h2 class="font-semibold mb-3">Tentang</h2>
      <label class="text-sm">Ringkas</label>
      <textarea name="about_short" rows="3" class="mt-1 w-full px-3 py-2 border rounded">{{ old('about_short',$profile->about_short) }}</textarea>
      <label class="text-sm mt-4 block">Detail</label>
      <textarea name="about_long" rows="6" class="mt-1 w-full px-3 py-2 border rounded">{{ old('about_long',$profile->about_long) }}</textarea>
    </div>

    <div id="social" class="rounded-2xl border bg-white p-5">
      <h2 class="font-semibold mb-3">Sosial & Link</h2>
      <div class="grid sm:grid-cols-3 gap-4">
        <div><label class="text-sm">GitHub</label><input name="github" type="url" value="{{ old('github',$profile->github) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
        <div><label class="text-sm">LinkedIn</label><input name="linkedin" type="url" value="{{ old('linkedin',$profile->linkedin) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
        <div><label class="text-sm">X/Twitter</label><input name="x" type="url" value="{{ old('x',$profile->x) }}" class="mt-1 w-full px-3 py-2 border rounded"></div>
      </div>
    </div>

    <div class="flex items-center gap-3">
      <button class="px-4 py-2 rounded-xl bg-black text-white hover:opacity-90">{{ $isEdit ? 'Simpan Perubahan' : 'Buat Profil' }}</button>
      <a href="{{ route('admin.profiles.index') }}" class="px-4 py-2 rounded-xl border">Batal</a>
    </div>
  </section>
</form>
@endsection
