@extends('backend.layouts.app')

@section('content')
<div class="flex items-center justify-between mb-6">
  <div>
    <h1 class="text-2xl font-semibold">Profiles</h1>
    <p class="text-sm text-zinc-600">Kelola data profil. Pilih satu sebagai aktif untuk ditampilkan di website.</p>
  </div>
  <a href="{{ route('admin.profiles.create') }}" class="px-4 py-2 rounded-xl bg-black text-white hover:opacity-90">Buat Profil</a>
</div>

@if (session('success'))
  <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3">{{ session('success') }}</div>
@endif

<form class="mb-4">
  <input name="q" value="{{ $q }}" placeholder="Cari nama/email/headline…" class="px-3 py-2 border rounded w-full sm:w-80">
</form>

<div class="overflow-x-auto rounded-2xl border bg-white">
  <table class="min-w-full text-sm">
    <thead class="bg-zinc-50 text-zinc-600">
      <tr>
        <th class="px-4 py-3 text-left">Profil</th>
        <th class="px-4 py-3 text-left">Kontak</th>
        <th class="px-4 py-3">Theme</th>
        <th class="px-4 py-3">Publik</th>
        <th class="px-4 py-3">Aktif</th>
        <th class="px-4 py-3"></th>
      </tr>
    </thead>
    <tbody class="divide-y">
      @forelse ($profiles as $p)
      <tr class="hover:bg-zinc-50/50">
        <td class="px-4 py-3">
          <div class="font-medium">{{ $p->name }}</div>
          <div class="text-zinc-500">{{ $p->headline }}</div>
        </td>
        <td class="px-4 py-3">
          <div>{{ $p->email }}</div>
          <div class="text-zinc-500">{{ $p->location }}</div>
        </td>
        <td class="px-4 py-3 text-center">{{ ucfirst($p->theme) }}</td>
        <td class="px-4 py-3 text-center">
          @if($p->is_public)
            <span class="inline-flex items-center px-2 py-0.5 rounded bg-emerald-100 text-emerald-700">Public</span>
          @else
            <span class="inline-flex items-center px-2 py-0.5 rounded bg-zinc-200 text-zinc-700">Private</span>
          @endif
        </td>
        <td class="px-4 py-3 text-center">
          @if($p->is_active)
            <span class="inline-flex items-center px-2 py-0.5 rounded bg-indigo-100 text-indigo-700">AKTIF</span>
          @else
            <span class="inline-flex items-center px-2 py-0.5 rounded bg-zinc-200 text-zinc-700">-</span>
          @endif
        </td>
        <td class="px-4 py-3">
          <div class="flex flex-wrap gap-2 justify-end">
            <a href="{{ route('admin.profiles.edit',$p) }}" class="px-3 py-1.5 rounded border">Edit</a>

            <form action="{{ route('admin.profiles.togglePublic',$p) }}" method="POST">@csrf @method('PATCH')
              <button class="px-3 py-1.5 rounded border">{{ $p->is_public ? 'Jadikan Private' : 'Jadikan Public' }}</button>
            </form>

            <form action="{{ route('admin.profiles.toggleActive',$p) }}" method="POST">@csrf @method('PATCH')
              <button class="px-3 py-1.5 rounded border">{{ $p->is_active ? 'Nonaktifkan' : 'Aktifkan' }}</button>
            </form>

            <form action="{{ route('admin.profiles.use',$p) }}" method="POST" onsubmit="return confirm('Gunakan profil ini sebagai profil aktif tunggal?');">
              @csrf
              <button class="px-3 py-1.5 rounded bg-black text-white hover:opacity-90">Pakai Data</button>
            </form>

            <form action="{{ route('admin.profiles.destroy',$p) }}" method="POST" onsubmit="return confirm('Hapus profil ini?');">
              @csrf @method('DELETE')
              <button class="px-3 py-1.5 rounded border text-rose-600">Hapus</button>
            </form>
          </div>
        </td>
      </tr>
      @empty
      <tr><td colspan="6" class="px-4 py-6 text-center text-zinc-500">Belum ada data.</td></tr>
      @endforelse
    </tbody>
  </table>
</div>

<div class="mt-4">
  {{ $profiles->links() }}
</div>
@endsection
