@extends('backend.layouts.app')

@section('content')
  <div class="mx-auto max-w-5xl">
    {{-- Header --}}
    <div class="mb-6 flex items-center justify-between gap-3">
      <div>
        <div class="text-xs text-zinc-500">Dashboard / Skills / <span class="text-zinc-700">Tambah</span></div>
        <h1 class="text-2xl font-semibold mt-1">Tambah Skill</h1>
        <p class="text-sm text-zinc-600 mt-1">Masukkan nama, ikon (opsional), dan status aktif.</p>
      </div>
      <a href="{{ route('admin.skills.index') }}" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl border hover:bg-zinc-50">← Kembali</a>
    </div>

    @if ($errors->any())
      <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-700 p-3 text-sm">
        <div class="font-medium mb-1">Periksa kembali isianmu:</div>
        <ul class="list-disc list-inside space-y-0.5">
          @foreach ($errors->all() as $e) <li>{{ $e }}</li> @endforeach
        </ul>
      </div>
    @endif

    <div class="rounded-2xl border bg-white/90 backdrop-blur p-5 shadow-sm">
      <form action="{{ route('admin.skills.store') }}" method="POST" class="grid md:grid-cols-5 gap-6">
        @csrf

        {{-- LEFT --}}
        <div class="md:col-span-3 space-y-5">
          {{-- Nama --}}
          <div>
            <label for="name" class="text-[13px] font-medium text-zinc-800">Nama <span class="text-rose-600">*</span></label>
            <div class="mt-1 relative">
              <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                  <path d="M12 12a4 4 0 1 0-4-4 4 4 0 0 0 4 4Z" stroke="currentColor" stroke-width="1.5"/>
                  <path d="M4 20a8 8 0 0 1 16 0" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                </svg>
              </span>
              <input id="name" name="name" value="{{ old('name') }}" required autofocus
                     class="w-full pl-10 pr-3 py-2.5 rounded-xl border bg-white shadow-sm transition focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('name') ring-2 ring-rose-500 border-rose-500 @enderror">
            </div>
            @error('name') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
          </div>

          {{-- Icon --}}
          <div>
            <label for="icon" class="text-[13px] font-medium text-zinc-800">Icon (opsional)</label>
            <div class="mt-1 relative">
              <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                  <path d="m12 3 8 4.5v9L12 21 4 16.5v-9L12 3Z" stroke="currentColor" stroke-width="1.5"/>
                  <path d="M20 7.5 12 12M12 12 4 7.5M12 12v9" stroke="currentColor" stroke-width="1.5"/>
                </svg>
              </span>
              <input id="icon" name="icon" value="{{ old('icon') }}"
                     placeholder="cth: fa-brands fa-laravel atau emoji (🛠️)"
                     class="w-full pl-10 pr-10 py-2.5 rounded-xl border bg-white shadow-sm transition focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 @error('icon') ring-2 ring-rose-500 border-rose-500 @enderror">
              <span id="iconPreview" class="absolute inset-y-0 right-0 pr-3 flex items-center text-zinc-600 text-base"></span>
            </div>
            <p class="text-xs text-zinc-500 mt-1">Font Awesome: <code>fa-brands fa-laravel</code> (pastikan FA dimuat). Emoji juga bisa.</p>
            @error('icon') <p class="text-rose-600 text-sm mt-1">{{ $message }}</p> @enderror
          </div>

          {{-- Status --}}
          <div class="flex items-center justify-between gap-3 rounded-xl border bg-zinc-50 px-4 py-3">
            <div>
              <div class="text-sm font-medium">Status</div>
              <p class="text-xs text-zinc-600">Atur apakah skill ini aktif ditampilkan.</p>
            </div>

            {{-- HIDDEN 0 + CHECKBOX 1 --}}
            <input type="hidden" name="is_active" value="0">
            <label for="is_active" class="inline-flex items-center cursor-pointer select-none">
              <input type="checkbox" id="is_active" name="is_active" value="1" class="peer sr-only"
                     {{ old('is_active', 1) ? 'checked' : '' }}>
              <span class="w-11 h-6 rounded-full border bg-zinc-200 peer-checked:bg-indigo-600 transition relative after:content-[''] after:absolute after:top-0.5 after:left-0.5 after:w-5 after:h-5 after:bg-white after:rounded-full after:shadow after:transition peer-checked:after:translate-x-5"></span>
              <span class="ml-3 text-sm text-zinc-700 peer-checked:text-indigo-700">Active</span>
            </label>
          </div>

          <div class="pt-2 flex items-center gap-3">
            <button class="px-5 py-2.5 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 shadow-sm">Simpan</button>
            <a href="{{ route('admin.skills.index') }}" class="px-5 py-2.5 rounded-xl border hover:bg-zinc-50">Batal</a>
          </div>
        </div>

        {{-- RIGHT: live preview --}}
        <div class="md:col-span-2">
          <div class="rounded-xl border bg-zinc-50 p-4 sticky top-4">
            <div class="text-sm font-medium mb-3">Preview</div>
            <div class="rounded-xl border bg-white p-4">
              <div class="flex items-start justify-between gap-3">
                <div>
                  <div id="pvName" class="font-semibold">{{ old('name') ?: 'Nama Skill' }}</div>
                  <div class="text-xs text-zinc-600 mt-0.5">
                    Icon: <span id="pvIconText">{!! old('icon') ? '<code>'.e(old('icon')).'</code>' : '<code>—</code>' !!}</span>
                  </div>
                </div>
                @php $active = (bool) old('is_active', 1); @endphp
                <span id="pvStatus" class="px-2 py-1 text-xs rounded {{ $active ? 'bg-green-100 text-green-700' : 'bg-rose-100 text-rose-700' }}">
                  {{ $active ? 'Active' : 'Inactive' }}
                </span>
              </div>
            </div>
            <p class="text-[11px] text-zinc-500 mt-2">Preview ini hanya ilustrasi tampilan pada daftar.</p>
          </div>
        </div>
      </form>
    </div>
  </div>
@endsection

@push('scripts')
<script>
(function(){
  const nameInput = document.getElementById('name');
  const iconInput = document.getElementById('icon');
  const activeInput = document.getElementById('is_active');

  const pvName = document.getElementById('pvName');
  const pvIconText = document.getElementById('pvIconText');
  const pvStatus = document.getElementById('pvStatus');
  const iconPreview = document.getElementById('iconPreview');

  function updatePreview(){
    pvName.textContent = (nameInput.value || '').trim() || 'Nama Skill';
    if (activeInput.checked){
      pvStatus.textContent = 'Active';
      pvStatus.className = 'px-2 py-1 text-xs rounded bg-green-100 text-green-700';
    } else {
      pvStatus.textContent = 'Inactive';
      pvStatus.className = 'px-2 py-1 text-xs rounded bg-rose-100 text-rose-700';
    }
    const v = (iconInput.value || '').trim();
    iconPreview.innerHTML = '';
    if (!v) { pvIconText.innerHTML = '<code>—</code>'; return; }
    if (v.includes(' ')) { pvIconText.innerHTML = `<code>${escapeHtml(v)}</code>`; const i=document.createElement('i'); i.className=v; iconPreview.appendChild(i); }
    else { pvIconText.textContent = v; iconPreview.textContent = v; }
  }
  function escapeHtml(str){return str.replace(/[&<>"']/g, s => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[s]));}
  nameInput.addEventListener('input',  updatePreview);
  iconInput.addEventListener('input',  updatePreview);
  activeInput.addEventListener('change', updatePreview);
  updatePreview();
})();
</script>
@endpush
