@extends('backend.layouts.app')

@section('content')
  <div class="max-w-6xl">
    <h1 class="text-2xl font-semibold mb-6">Skills</h1>

    @if (session('status'))
      <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-3 text-sm">
        {{ session('status') }}
      </div>
    @endif

    <div class="rounded-2xl border bg-white p-5 shadow-sm">
      {{-- Toolbar --}}
      <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between">
        <form method="GET" class="flex w-full md:w-auto items-stretch gap-2"
              onsubmit="this.querySelector('button[type=submit]').disabled=true">
          <input type="text" name="q" value="{{ $q }}"
                 placeholder="Cari nama skill…"
                 class="flex-1 w-full md:w-72 px-3 py-2 rounded-xl border focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
          <button type="submit" class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Cari</button>
          @if($q)
            <a href="{{ route('admin.skills.index') }}" class="px-4 py-2 rounded-xl border hover:bg-zinc-50">Reset</a>
          @endif
        </form>

        <a href="{{ route('admin.skills.create') }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 self-start md:self-auto">
          <span class="text-lg">＋</span> Tambah Skill
        </a>
      </div>

      {{-- Bulk Action Bar --}}
      <form id="bulkForm" action="{{ route('admin.skills.bulk-status') }}" method="POST">
        @csrf
        <input type="hidden" name="action" id="bulkAction" value="">
        <div id="bulkBar" class="hidden mt-4 rounded-xl border bg-zinc-50 px-3 py-2 text-sm flex items-center justify-between">
          <div>
            <span id="bulkCount" class="font-semibold">0</span> item dipilih
          </div>
          <div class="flex flex-wrap gap-2">
            <button type="button" data-action="activate" class="px-3 py-1.5 rounded-lg border hover:bg-white" title="Aktifkan yang dipilih">Set Active</button>
            <button type="button" data-action="deactivate" class="px-3 py-1.5 rounded-lg border hover:bg-white" title="Nonaktifkan yang dipilih">Set Inactive</button>
            <button type="button" data-action="delete" class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50" title="Hapus yang dipilih">Delete</button>
          </div>
        </div>
      </form>

      {{-- Desktop Table --}}
      <div class="hidden md:block mt-4 overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead>
            <tr class="border-b text-zinc-600">
              <th class="py-2 px-3 w-12">
                <label class="inline-flex items-center gap-2">
                  <input type="checkbox" id="selectAllDesktop" class="h-4 w-4">
                </label>
              </th>
              <th class="py-2 px-3 text-left">Nama</th>
              <th class="py-2 px-3 text-left">Icon</th>
              <th class="py-2 px-3 text-left">Status</th>
              <th class="py-2 px-3 text-right">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @forelse ($skills as $skill)
              <tr class="border-b last:border-0 hover:bg-zinc-50/50">
                <td class="py-2 px-3 align-middle">
                  <input type="checkbox" value="{{ $skill->id }}" class="rowCheck h-4 w-4" aria-label="Pilih {{ $skill->name }}">
                </td>
                <td class="py-2 px-3 align-middle">
                  <div class="font-medium">{{ $skill->name }}</div>
                </td>
                <td class="py-2 px-3 align-middle">
                  <code class="text-xs">{{ $skill->icon ?: '—' }}</code>
                </td>
                <td class="py-2 px-3 align-middle">
                  <form action="{{ route('admin.skills.toggle', $skill) }}" method="POST">
                    @csrf @method('PATCH')
                    @if($skill->is_active)
                      <button class="px-2 py-1 text-xs rounded bg-green-100 text-green-700 hover:bg-green-200"
                              title="Klik untuk menonaktifkan">
                        Active
                      </button>
                    @else
                      <button class="px-2 py-1 text-xs rounded bg-rose-100 text-rose-700 hover:bg-rose-200"
                              title="Klik untuk mengaktifkan">
                        Inactive
                      </button>
                    @endif
                  </form>
                </td>
                <td class="py-2 px-3 align-middle">
                  <div class="flex justify-end gap-2">
                    <a href="{{ route('admin.skills.edit', $skill) }}"
                       class="px-3 py-1.5 rounded-lg border hover:bg-white">Edit</a>
                    <form action="{{ route('admin.skills.destroy', $skill) }}" method="POST"
                          onsubmit="return confirm('Hapus skill ini?')">
                      @csrf @method('DELETE')
                      <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50">Delete</button>
                    </form>
                  </div>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="py-10">
                  <div class="flex flex-col items-center gap-2 text-zinc-600">
                    <div class="text-3xl">🛠️</div>
                    <div class="font-medium">Belum ada data.</div>
                    <a href="{{ route('admin.skills.create') }}"
                       class="mt-1 inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700">
                      Tambah Skill Pertama
                    </a>
                  </div>
                </td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      {{-- Mobile Card List --}}
      <div class="md:hidden mt-4 space-y-3">
        @forelse ($skills as $skill)
          <div class="rounded-xl border p-3">
            <div class="flex items-start justify-between gap-3">
              <div class="flex items-start gap-2">
                <input type="checkbox" value="{{ $skill->id }}" class="rowCheck h-4 w-4 mt-1" aria-label="Pilih {{ $skill->name }}">
                <div>
                  <div class="font-semibold">{{ $skill->name }}</div>
                  <div class="text-xs text-zinc-600 mt-0.5">
                    Icon: <code>{{ $skill->icon ?: '—' }}</code>
                  </div>
                </div>
              </div>
              <form action="{{ route('admin.skills.toggle', $skill) }}" method="POST" class="shrink-0">
                @csrf @method('PATCH')
                @if($skill->is_active)
                  <button class="px-2 py-1 text-xs rounded bg-green-100 text-green-700 hover:bg-green-200">Active</button>
                @else
                  <button class="px-2 py-1 text-xs rounded bg-rose-100 text-rose-700 hover:bg-rose-200">Inactive</button>
                @endif
              </form>
            </div>
            <div class="mt-3 flex items-center justify-end gap-2">
              <a href="{{ route('admin.skills.edit', $skill) }}"
                 class="px-3 py-1.5 rounded-lg border hover:bg-white">Edit</a>
              <form action="{{ route('admin.skills.destroy', $skill) }}" method="POST"
                    onsubmit="return confirm('Hapus skill ini?')">
                @csrf @method('DELETE')
                <button class="px-3 py-1.5 rounded-lg border text-rose-600 hover:bg-rose-50">Delete</button>
              </form>
            </div>
          </div>
        @empty
          <div class="rounded-xl border p-6 text-center text-zinc-600">
            <div class="text-3xl mb-1">🛠️</div>
            Belum ada data.<br>
            <a href="{{ route('admin.skills.create') }}"
               class="inline-block mt-3 px-4 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700">
              Tambah Skill Pertama
            </a>
          </div>
        @endforelse
      </div>

      {{-- Pagination --}}
      @if ($skills->hasPages())
        <div class="mt-5">
          {{ $skills->links() }}
        </div>
      @endif
    </div>
  </div>
@endsection

@push('scripts')
<script>
(function(){
  const bulkForm = document.getElementById('bulkForm');
  const bulkActionInput = document.getElementById('bulkAction');
  const bulkBar = document.getElementById('bulkBar');
  const bulkCount = document.getElementById('bulkCount');

  const selectAllDesktop = document.getElementById('selectAllDesktop');
  const rowChecks = () => Array.from(document.querySelectorAll('.rowCheck'));

  // Select All (desktop)
  selectAllDesktop?.addEventListener('change', (e)=>{
    rowChecks().forEach(c => c.checked = e.target.checked);
    refreshBulk();
  });

  // Per-row change
  document.addEventListener('change', (e)=>{
    if (e.target.classList.contains('rowCheck')) refreshBulk();
  });

  function refreshBulk(){
    const checks = rowChecks();
    const selected = checks.filter(c => c.checked);
    const total = checks.length;

    // sync select all state
    if (selectAllDesktop) {
      selectAllDesktop.checked = total>0 && selected.length === total;
      selectAllDesktop.indeterminate = selected.length>0 && selected.length<total;
    }

    // toggle bulk bar
    if (selected.length > 0) {
      bulkBar.classList.remove('hidden');
      bulkCount.textContent = selected.length;
    } else {
      bulkBar.classList.add('hidden');
      bulkCount.textContent = 0;
    }
  }

  // Kirim bulk action
  bulkForm?.querySelectorAll('button[data-action]').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const ids = rowChecks().filter(c => c.checked).map(c => c.value);
      if (ids.length === 0) {
        alert('Pilih minimal 1 item.');
        return;
      }
      const action = btn.getAttribute('data-action');
      if (action === 'delete' && !confirm('Hapus semua pilihan?')) return;

      // bersihkan semua input ids[] lama
      bulkForm.querySelectorAll('input[name="ids[]"]').forEach(el=> el.remove());

      // injeksi ids baru
      ids.forEach(id=>{
        const hid = document.createElement('input');
        hid.type = 'hidden'; hid.name = 'ids[]'; hid.value = id;
        bulkForm.appendChild(hid);
      });

      bulkActionInput.value = action;
      bulkForm.submit();
    });
  });

  // Initial
  refreshBulk();
})();
</script>
@endpush
