@extends('backend.layouts.app')

@section('content')
{{-- ===== Header ===== --}}
<div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-5">
  <div>
    <h1 class="text-2xl font-bold tracking-tight">Videos</h1>
    <p class="text-sm text-zinc-500">Kelola video yang tampil di portofolio kamu.</p>
  </div>

  <a href="{{ route('admin.videos.create') }}"
     class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-gradient-to-r from-indigo-600 to-fuchsia-600 text-white shadow hover:shadow-lg transition">
    <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none"><path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
    New Video
  </a>
</div>

{{-- ===== Search ===== --}}
<form method="GET" class="mb-5">
  <div class="relative max-w-xl">
    <input name="q" value="{{ $q ?? '' }}" placeholder="Cari judul, slug…"
           class="w-full px-4 py-2.5 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500"/>
    @if(!empty($q))
      <a href="{{ route('admin.videos.index') }}"
         class="absolute right-2 top-1/2 -translate-y-1/2 text-xs text-zinc-500 hover:underline">Clear</a>
    @endif
  </div>
</form>

{{-- ===== Grid Cards ===== --}}
@if($videos->count())
  <div class="grid sm:grid-cols-2 lg:grid-cols-3 2xl:grid-cols-4 gap-5">
    @foreach ($videos as $v)
      @php
        $thumbUrl = $v->thumb_path ? asset('storage/'.$v->thumb_path) : null;
        $videoUrl = $v->file_path  ? asset('storage/'.$v->file_path)  : null;
      @endphp

      <div class="group rounded-2xl overflow-hidden border bg-white/70 backdrop-blur-sm shadow-sm hover:shadow-xl hover:border-zinc-200 transition">
        {{-- ===== Preview (fix overlap) ===== --}}
        <div class="relative aspect-video bg-zinc-100 overflow-hidden">
          @if($thumbUrl)
            <img src="{{ $thumbUrl }}"
                 alt="thumb {{ $v->title }}"
                 loading="lazy"
                 class="absolute inset-0 w-full h-full object-cover group-hover:scale-[1.03] transition-transform duration-500">
          @elseif($videoUrl)
            <video src="{{ $videoUrl }}"
                   class="absolute inset-0 w-full h-full object-cover"
                   muted playsinline preload="metadata"></video>
          @else
            <div class="absolute inset-0 grid place-items-center text-zinc-400 text-sm">No preview</div>
          @endif>

          {{-- badges --}}
          <div class="absolute top-2 left-2 flex gap-2 z-10">
            <span class="px-2 py-0.5 rounded-full text-[11px] font-medium text-white/90 border border-white/20 bg-black/30 backdrop-blur">
              {{ $v->published_at ? 'Published' : 'Draft' }}
            </span>
            <span class="px-2 py-0.5 rounded-full text-[11px] font-medium text-white/90 border border-white/20 bg-black/30 backdrop-blur">
              {{ $v->published_at ? $v->published_at->diffForHumans() : '—' }}
            </span>
          </div>

          {{-- gradient hover (tidak blok klik) --}}
          <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/10 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition"></div>
        </div>

        {{-- ===== Body (angkat z-index agar di atas preview) ===== --}}
        <div class="relative z-10 p-4">
          <div class="min-h-[54px]">
            <h3 class="font-semibold tracking-tight line-clamp-2 break-words">{{ $v->title }}</h3>
            <div class="text-xs text-zinc-500 mt-0.5 line-clamp-1 break-words">{{ $v->slug }}</div>
          </div>

          {{-- Meta strip --}}
          <div class="mt-3 flex items-center gap-2 text-xs">
            <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full border bg-white">
              <span class="w-1.5 h-1.5 rounded-full {{ $v->published_at ? 'bg-emerald-500' : 'bg-zinc-400' }}"></span>
              {{ $v->published_at ? 'Published' : 'Unpublished' }}
            </span>
          </div>

          {{-- Actions --}}
          <div class="mt-4 flex items-center justify-between">
            <form method="POST" action="{{ route('admin.videos.publish',$v) }}">
              @csrf @method('PATCH')
              <button class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg border bg-white text-xs hover:bg-zinc-50 transition">
                @if($v->published_at)
                  <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
                  Unpublish
                @else
                  <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
                  Publish
                @endif
              </button>
            </form>

            <div class="flex items-center gap-2">
              <a href="{{ route('admin.videos.edit',$v) }}"
                 class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg border bg-white text-xs hover:bg-zinc-50 transition">
                <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M4 20h4l10-10a2.828 2.828 0 10-4-4L4 16v4z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/></svg>
                Edit
              </a>

              <form method="POST" action="{{ route('admin.videos.destroy',$v) }}"
                    onsubmit="return confirm('Hapus video ini?')">
                @csrf @method('DELETE')
                <button class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-lg border bg-white text-xs text-rose-600 hover:bg-rose-50 transition">
                  <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="none"><path d="M6 7h12M9 7V5a2 2 0 012-2h2a2 2 0 012 2v2M9 11v6M15 11v6M5 7l1 14a2 2 0 002 2h8a2 2 0 002-2l1-14" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
                  Delete
                </button>
              </form>
            </div>
          </div>
        </div>
      </div>
    @endforeach
  </div>

  <div class="mt-6">{{ $videos->links() }}</div>
@else
  <div class="rounded-2xl border bg-white p-8 text-center shadow-sm">
    <div class="mx-auto w-12 h-12 grid place-items-center rounded-full bg-zinc-100 text-zinc-500">
      <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none"><path d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14m0-4v4m0-4L9 6m6 4l-6 4m0 0L4.447 16.276A1 1 0 013 15.382V8.618a1 1 0 011.447-.894L9 10m0 4V6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
    </div>
    <p class="mt-3 text-zinc-700 font-medium">Belum ada video.</p>
    <p class="text-zinc-500 text-sm">Klik tombol “New Video” untuk menambahkan.</p>
    <a href="{{ route('admin.videos.create') }}"
       class="mt-4 inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-black text-white shadow hover:shadow-lg transition">
      + New Video
    </a>
  </div>
@endif
@endsection
