@php $video ??= new \App\Models\Video(); @endphp

{{-- =================== HEADERS =================== --}}
<div class="mb-3">
  <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full border bg-white shadow-sm text-xs text-zinc-600">
    <span class="w-1.5 h-1.5 rounded-full {{ $video->exists ? 'bg-emerald-500' : 'bg-indigo-500' }}"></span>
    {{ $video->exists ? 'Edit Video' : 'Buat Video' }}
  </div>
</div>

{{-- =================== TITLE & SLUG =================== --}}
<div class="grid md:grid-cols-2 gap-4">
  <div>
    <label for="v-title" class="text-sm font-medium">Judul</label>
    <div class="relative">
      <input id="v-title" name="title" value="{{ old('title',$video->title) }}" required
             class="w-full mt-1 px-3 py-2 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500"
             maxlength="180">
      <span id="v-title-count" class="absolute right-2 top-1/2 mt-1 -translate-y-1/2 text-[11px] text-zinc-400">0/180</span>
    </div>
    <p class="text-xs text-zinc-500 mt-1">Judul akan jadi dasar slug (URL) secara otomatis.</p>
  </div>

  <div>
    <label for="v-slug" class="text-sm font-medium">Slug (opsional)</label>
    <div class="relative">
      <input id="v-slug" name="slug" value="{{ old('slug',$video->slug) }}"
             class="w-full mt-1 px-3 py-2 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500"
             maxlength="200" placeholder="contoh: cara-setup-cdn-vite">
      <button type="button" id="slug-lock"
              class="absolute right-2 top-1/2 -translate-y-1/2 text-[11px] px-2 py-0.5 rounded-lg border bg-white shadow-sm">
        Auto
      </button>
    </div>
    <p class="text-xs text-zinc-500 mt-1">Biarkan kosong untuk auto; klik tombol <strong>Auto</strong> untuk toggle.</p>
  </div>
</div>

{{-- =================== DESCRIPTION =================== --}}
<div class="mt-4">
  <label for="v-desc" class="text-sm font-medium">Deskripsi <span class="text-zinc-400">(Markdown didukung)</span></label>
  <textarea id="v-desc" name="description" rows="7"
            class="w-full mt-1 px-3 py-2 rounded-2xl border bg-white shadow-sm focus:ring-2 focus:ring-indigo-500">{{ old('description',$video->description) }}</textarea>
  <p class="text-xs text-zinc-500 mt-1">Bisa gunakan <code>**bold**</code>, <code>_italic_</code>, list, dll.</p>
</div>

{{-- =================== VIDEO =================== --}}
<div class="mt-4">
  <label class="text-sm font-medium">Video File {{ $video->exists ? '(biarkan kosong jika tidak diganti)' : '' }}</label>

  <div id="drop-video"
       class="mt-1 flex flex-col items-center justify-center gap-2 rounded-2xl border border-dashed p-5 bg-white shadow-sm hover:border-indigo-400 transition cursor-pointer">
    <div class="text-4xl leading-none select-none">🎬</div>
    <p class="text-sm text-zinc-700">Tarik & letakkan berkas video ke sini, atau klik untuk memilih.</p>
    <p class="text-xs text-zinc-500">Menerima semua format <code>video/*</code>. Disarankan MP4 (H.264).</p>
    <input id="file-video" type="file" name="file" accept="video/*" class="hidden">
  </div>

  <div id="preview-video" class="mt-2"></div>

  @if($video->exists && $video->url)
    <video src="{{ $video->url }}" class="w-full mt-2 rounded-xl border" controls playsinline></video>
  @endif
</div>

{{-- =================== STATUS (CHECKBOX PUBLISH/UNPUBLISH) =================== --}}
<div class="mt-4">
  <label class="text-sm font-medium">Status</label>
  <div class="mt-1 flex items-center justify-between gap-4 rounded-2xl border bg-white px-4 py-3 shadow-sm">
    <div class="text-sm">
      <div class="font-medium">Publish sekarang</div>
      <p class="text-xs text-zinc-500">Centang untuk mem-publish; kosongkan untuk Unpublish.</p>
    </div>

    <label class="inline-flex items-center cursor-pointer select-none">
      {{-- penting: kirim nilai 0 saat tidak dicentang --}}
      <input type="hidden" name="is_published" value="0">
      <input type="checkbox" id="v-publish" name="is_published" value="1" class="sr-only peer"
             {{ old('is_published', $video->published_at ? 1 : 0) ? 'checked' : '' }}>
      <span class="w-11 h-6 bg-zinc-300 rounded-full peer-checked:bg-emerald-500 relative transition">
        <span class="absolute top-0.5 left-0.5 w-5 h-5 bg-white rounded-full shadow transition peer-checked:translate-x-5"></span>
      </span>
      <span id="v-publish-label" class="ml-2 text-sm">{{ $video->published_at ? 'Publish' : 'Unpublish' }}</span>
    </label>
  </div>
</div>

{{-- =================== SMALL CSS =================== --}}
<style>
  .dz-hover { border-color: rgb(99,102,241) !important; background: #fafaff; }
</style>

{{-- =================== SCRIPTS =================== --}}
@push('scripts')
<script>
(function(){
  // ---------- Counter title
  const t = document.getElementById('v-title');
  const c = document.getElementById('v-title-count');
  function up(){ if(!t||!c) return; c.textContent = `${t.value.length}/180`; }
  t?.addEventListener('input', up); up();

  // ---------- Auto slug
  const s = document.getElementById('v-slug');
  const btn = document.getElementById('slug-lock');
  let auto = !s?.value;
  function toSlug(str){
    return (str||'').toLowerCase()
      .normalize('NFD').replace(/[\u0300-\u036f]/g,'')
      .replace(/[^a-z0-9]+/g,'-').replace(/^-+|-+$/g,'').substring(0,200);
  }
  const sync = ()=>{ if(auto && s) s.value = toSlug(t?.value||''); };
  t?.addEventListener('input', sync);
  s?.addEventListener('input', ()=>{ auto = false; btn.textContent='Man'; });
  btn?.addEventListener('click', ()=>{
    auto = !auto; btn.textContent = auto ? 'Auto' : 'Man';
    if(auto) sync();
  });

  // ---------- EasyMDE (opsional)
  const d = document.getElementById('v-desc');
  if (d && window.EasyMDE){
    new EasyMDE({
      element: d,
      spellChecker: false,
      minHeight: '220px',
      status: false,
      autoDownloadFontAwesome: false,
      placeholder: 'Tulis deskripsi video…',
      renderingConfig: { singleLineBreaks: false },
      toolbar: ['bold','italic','heading','|','quote','unordered-list','ordered-list','|','link','preview','guide']
    });
  }

  // ---------- Drag & drop video + preview
  function setupDrop(dropId, inputId, onFile){
    const dz = document.getElementById(dropId);
    const fi = document.getElementById(inputId);
    if(!dz || !fi) return;

    dz.addEventListener('click', e=>{ if(e.target === dz) fi.click(); });

    ['dragenter','dragover'].forEach(evt=>{
      dz.addEventListener(evt, e=>{ e.preventDefault(); dz.classList.add('dz-hover'); });
    });
    ['dragleave','drop'].forEach(evt=>{
      dz.addEventListener(evt, e=>{ e.preventDefault(); dz.classList.remove('dz-hover'); });
    });
    dz.addEventListener('drop', e=>{
      const files = e.dataTransfer?.files;
      if(files?.length){ fi.files = files; onFile(files[0]); }
    });
    fi.addEventListener('change', ()=>{ const f = fi.files?.[0]; if(f) onFile(f); });
  }
  setupDrop('drop-video','file-video', file=>{
    const box = document.getElementById('preview-video');
    if(!box) return;
    const url = URL.createObjectURL(file);
    box.innerHTML = `<video src="${url}" class="w-full rounded-xl border" controls playsinline></video>`;
  });

  // ---------- Label Publish / Unpublish
  const cb = document.getElementById('v-publish');
  const lb = document.getElementById('v-publish-label');
  cb?.addEventListener('change', ()=>{ lb.textContent = cb.checked ? 'Publish' : 'Unpublish'; });
})();
</script>
@endpush
