@props(['project'])

@php
  $images = ($project->media ?? collect())->where('kind','image')->values();
  $cover  = $images->first();
@endphp

<div class="group rounded-2xl border border-zinc-200/60 bg-white/70 backdrop-blur-sm overflow-hidden shadow-sm hover:shadow-xl hover:border-zinc-200 transition-all duration-300">
  {{-- HERO / SLIDER --}}
  <div class="relative">
    <div class="slider" x-data x-init>
      <div class="slider-rail flex overflow-x-auto snap-x snap-mandatory scroll-smooth no-scrollbar"
           onscroll="window.__dotSync && window.__dotSync(this)"
           data-dots-id="dots-{{ $project->id }}">
        @forelse($images as $img)
          <div class="snap-start shrink-0 w-full aspect-[16/10] relative overflow-hidden">
            <img
              src="{{ asset('storage/'.$img->path) }}"
              alt="{{ $project->title }}"
              loading="lazy"
              class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-[1.04]">
            {{-- shimmer skeleton untuk slow network (CSS di bawah) --}}
            <div class="skeleton" aria-hidden="true"></div>
          </div>
        @empty
          <div class="snap-start shrink-0 w-full aspect-[16/10] grid place-items-center bg-gradient-to-br from-zinc-100 to-zinc-200 text-zinc-500">
            Tidak ada gambar
          </div>
        @endforelse
      </div>

      {{-- NAV BUTTONS
      <button type="button" class="nav left-3"
              onclick="const r=this.nextElementSibling.querySelector('.slider-rail')||this.closest('.slider').querySelector('.slider-rail'); r && r.scrollBy({left:-r.clientWidth,behavior:'smooth'})">‹</button>
      <button type="button" class="nav right-3"
              onclick="const r=this.previousElementSibling.querySelector('.slider-rail')||this.closest('.slider').querySelector('.slider-rail'); r && r.scrollBy({left:r.clientWidth,behavior:'smooth'})">›</button> --}}

      {{-- DOTS --}}
      <div id="dots-{{ $project->id }}" class="absolute -bottom-2 left-0 right-0 flex justify-center gap-1.5 py-4 pointer-events-none">
        @for($i=0; $i<max(1,$images->count()); $i++)
          <span class="dot"></span>
        @endfor
      </div>
    </div>

    {{-- (dipindah) GLASS BADGES: dihapus dari atas gambar --}}
    {{-- sebelumnya ada badge 👁 & ❤️ di sini --}}
    <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/0 via-transparent to-white/0 group-hover:via-white/10"></div>
  </div>

  {{-- BODY --}}
  <div class="p-4">
    <a href="{{ route('projects.show', $project) }}" class="block">
      <h3 class="font-semibold tracking-tight text-zinc-900 line-clamp-2">
        {{ $project->title }}
      </h3>
      <p class="mt-1 text-sm text-zinc-600 line-clamp-2">
        {{ $project->excerpt }}
      </p>
    </a>

    <div class="mt-4 flex items-center justify-between">
      {{-- Tanggal + ikon dipindahkan ke sini --}}
      <div class="flex items-center gap-3 text-xs text-zinc-500">
        <span>{{ optional($project->published_at)->diffForHumans() ?? 'Draft' }}</span>

        <span class="inline-flex items-center gap-1" title="Views">
          {{-- eye --}}
          <svg xmlns="http://www.w3.org/2000/svg" class="h-[14px] w-[14px]" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
            <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7-11-7-11-7Z"/>
            <circle cx="12" cy="12" r="3"/>
          </svg>
          {{ number_format((int)($project->view_count ?? 0)) }}
        </span>

        <span class="inline-flex items-center gap-1" title="Likes">
          {{-- heart --}}
          <svg xmlns="http://www.w3.org/2000/svg" class="h-[14px] w-[14px] text-rose-500" viewBox="0 0 24 24" fill="currentColor">
            <path d="M12.001 4.529c2.349-2.532 6.85-1.02 6.85 2.57 0 2.02-1.23 3.55-2.61 4.87-1.45 1.38-3.06 2.52-4.24 3.43-1.18-.91-2.79-2.05-4.24-3.43-1.38-1.32-2.61-2.85-2.61-4.87 0-3.59 4.5-5.102 6.85-2.57z"/>
          </svg>
          {{ number_format((int)($project->like_count ?? 0)) }}
        </span>
      </div>

      {{-- LIKE BUTTON (AJAX) --}}
      <form method="POST" action="{{ route('projects.like', $project) }}"
            onsubmit="event.preventDefault(); const btn=this.querySelector('button'); btn.disabled=true;
                     fetch(this.action,{method:'POST',headers:{'X-CSRF-TOKEN':'{{ csrf_token() }}','Accept':'application/json'}})
                      .then(r=>r.json()).then(d=>{
                        btn.dataset.liked = d.liked ? '1':'0';
                        btn.innerHTML = (d.liked? '💖 Liked' : '🤍 Like') + ' <span class=&quot;ml-1 opacity-80&quot;>(' + d.like_count + ')</span>';
                      }).catch(()=>{}).finally(()=>btn.disabled=false);">
        @csrf
        <button type="submit"
                class="px-3 py-1.5 rounded-xl text-sm border shadow-sm bg-white hover:bg-rose-50 text-rose-600 transition"
                data-liked="0">
          🤍 Like <span class="ml-1 opacity-80">({{ (int)($project->like_count ?? 0) }})</span>
        </button>
      </form>
    </div>
  </div>
</div>

@pushOnce('styles')
<style>
  .no-scrollbar::-webkit-scrollbar{display:none}
  .no-scrollbar{-ms-overflow-style:none;scrollbar-width:none}

  .slider .nav{
    position:absolute; top:50%; transform:translateY(-50%);
    z-index:10; width:38px; height:38px; display:grid; place-items:center;
    border-radius:9999px; border:1px solid rgba(0,0,0,.06);
    background: rgba(255,255,255,.9); color:#0f172a;
    box-shadow: 0 6px 24px rgba(0,0,0,.08);
    transition: all .2s ease;
  }
  .slider .nav:hover{ background:#fff; transform:translateY(-50%) scale(1.04) }
  .slider .left-3{ left:.75rem } .slider .right-3{ right:.75rem }

  .glass-badge{
    font-size:12px; padding:.35rem .5rem; border-radius:9999px;
    color:#fff; background:rgba(17,17,17,.45); backdrop-filter: blur(6px);
    border:1px solid rgba(255,255,255,.18);
  }

  /* dots */
  .dot{
    width:8px; height:8px; border-radius:9999px;
    background:rgba(255,255,255,.55); box-shadow:0 0 0 1px rgba(0,0,0,.05) inset;
    transition:all .2s; transform:translateY(2px);
  }
  .dot.active{ width:22px; background:#fff; transform:translateY(0); border-radius:9999px }

  /* shimmer skeleton layers (hidden once image loaded) */
  .skeleton{
    position:absolute; inset:0; background:linear-gradient(100deg,#e4e4e7 20%,#f4f4f5 40%,#e4e4e7 60%);
    background-size:200% 100%; animation:shine 1.2s linear infinite; opacity:.0; pointer-events:none;
  }
  @keyframes shine{ to{ background-position-x:-200% } }
  .group img[loading="lazy"] + .skeleton{ opacity:.7 }
  .group img:not([loading]) + .skeleton{ opacity:0 }
</style>
@endPushOnce

@pushOnce('scripts')
<script>
  // Sinkronkan dot indicator dengan posisi scroll
  window.__dotSync = function(rail){
    const dotsWrap = document.getElementById(rail.getAttribute('data-dots-id')); if(!dotsWrap) return;
    const dots = dotsWrap.querySelectorAll('.dot'); if(!dots.length) return;
    const idx = Math.round(rail.scrollLeft / rail.clientWidth);
    dots.forEach((d,i)=>d.classList.toggle('active', i===idx));
  };
  // Inisialisasi dot pertama aktif
  window.addEventListener('load', () => {
    document.querySelectorAll('[id^="dots-"]').forEach(w => w.querySelector('.dot')?.classList.add('active'));
  });
</script>
@endPushOnce

