@extends('frontend.layouts.app')

@section('content')
    @php
        /**
         * Formatter aman: escape HTML -> apply **bold**, *italic*, __underline__ -> nl2br
         */
        $fmt = function (?string $text) {
            if (!$text) return '';
            $escaped = e($text);

            // **bold**, __underline__, *italic* (hindari bentrok dengan **)
            $patterns = [
                '/\*\*(?=\S)(.+?)(?<=\S)\*\*/s',                   // **bold**
                '/__(?=\S)(.+?)(?<=\S)__/s',                       // __underline__
                '/(?<!\*)\*(?=\S)(.+?)(?<=\S)(?<!\*)\*/s',         // *italic*
            ];
            $replacements = [
                '<strong>$1</strong>',
                '<u>$1</u>',
                '<em>$1</em>',
            ];
            $formatted = preg_replace($patterns, $replacements, $escaped);

            return nl2br($formatted, false); // newline -> <br>
        };
    @endphp

    <section class="grid md:grid-cols-2 gap-8 items-center">
        <div class="space-y-4">
            <h1 class="text-3xl md:text-4xl font-bold">
                Tentang
                <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-500 to-emerald-500">
                    {{ $profile->name ?? 'Nama Kamu' }}
                </span>
            </h1>

            <p class="text-zinc-600 richfmt">
                {!! $fmt($profile->headline ?? 'Tulis headline singkatmu di admin.') !!}
            </p>

            {{-- Skills dari database (fallback ke list default bila kosong) --}}
            @if (isset($skills) && $skills->count())
                <ul class="grid sm:grid-cols-2 gap-3 text-sm">
                    @foreach ($skills as $skill)
                        <li class="rounded-xl border bg-white p-4">
                            @if ($skill->icon)
                                <i class="{{ $skill->icon }}"></i>
                                &nbsp;
                            @endif
                            {{ $skill->name }}
                        </li>
                    @endforeach
                </ul>
            @else
                <ul class="grid sm:grid-cols-2 gap-3 text-sm">
                    <li class="rounded-xl border bg-white p-4">Laravel • Filament</li>
                    <li class="rounded-xl border bg-white p-4">Tailwind • Vite</li>
                    <li class="rounded-xl border bg-white p-4">MySQL • Redis</li>
                    <li class="rounded-xl border bg-white p-4">Git • CI/CD</li>
                </ul>
            @endif
        </div>

        {{-- Foto dari database (fallback ke placeholder bila belum ada) --}}
        @php
            $avatarUrl = null;
            if (isset($profile) && $profile) {
                // Jika punya accessor avatar_url pakai itu; kalau tidak, gunakan path storage
                $avatarUrl = $profile->avatar_url ?? ($profile->avatar_path ? asset('storage/' . $profile->avatar_path) : null);
            }
        @endphp
        <div class="rounded-2xl overflow-hidden border bg-white shadow-sm">
            <img
                src="{{ $avatarUrl ?: 'https://images.unsplash.com/photo-1556157382-97eda2d62296?q=80&w=1600&auto=format&fit=crop' }}"
                alt="{{ $profile->name ?? 'workspace' }}"
                class="w-full object-cover aspect-[16/10]">
        </div>
    </section>

    {{-- Riwayat Pekerjaan dari DB (tampilan seperti sebelumnya + scroll pada deskripsi) --}}
    @if (isset($experiences) && $experiences->count())
        <section class="mt-12">
            <h2 class="text-xl font-semibold mb-4">Riwayat Pekerjaan</h2>

            <div class="space-y-4">
                @foreach ($experiences as $exp)
                    <div class="rounded-2xl border bg-white p-4 shadow-sm">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <div class="font-medium">{{ $exp->title }} — {{ $exp->company }}</div>
                                <div class="text-sm text-zinc-600">
                                    @if ($exp->location)
                                        {{ $exp->location }} •
                                    @endif
                                    {{ optional($exp->started_at)->format('M Y') }} —
                                    {{ $exp->ended_at ? $exp->ended_at->format('M Y') : 'Sekarang' }}
                                </div>
                            </div>

                            @if (!empty($exp->is_current))
                                <span class="px-2 py-1 text-xs rounded bg-emerald-100 text-emerald-700">Current</span>
                            @endif
                        </div>

                        @if ($exp->description)
                            {{-- Deskripsi: batasi tinggi & aktifkan scroll jika panjang + auto bold/italic/underline --}}
                            <div class="mt-2 text-sm text-zinc-700 leading-relaxed max-h-40 overflow-y-auto pr-1 custom-scroll richfmt" tabindex="0">
                                {!! $fmt($exp->description) !!}
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </section>
    @else
        {{-- Empty state jika belum ada data --}}
        <section class="mt-12">
            <h2 class="text-xl font-semibold mb-4">Riwayat Pekerjaan</h2>
            <div class="rounded-2xl border bg-white p-6 text-center text-zinc-600">
                Belum ada riwayat pekerjaan yang ditampilkan.
            </div>
        </section>
    @endif

    {{-- Scrollbar tipis & halus untuk deskripsi panjang + underline yang rapi --}}
    <style>
        .custom-scroll {
            scrollbar-width: thin;
            scrollbar-color: #d4d4d8 transparent; /* zinc-300 */
            overscroll-behavior: contain;
            scrollbar-gutter: stable;
        }
        .custom-scroll::-webkit-scrollbar { width: 6px; }
        .custom-scroll::-webkit-scrollbar-track { background: transparent; }
        .custom-scroll::-webkit-scrollbar-thumb {
            background-color: #d4d4d8; /* zinc-300 */
            border-radius: 9999px;
        }

        /* Styling underline supaya enak dibaca */
        .richfmt u {
            text-underline-offset: 3px;
            text-decoration-thickness: from-font;
        }
    </style>
@endsection

