@extends('frontend.layouts.app')

@section('content')
    @php
        // Ambil dari DB (Profile); fallback kalau belum diisi
        $email    = $profile->email    ?? 'hello@example.com';
        $linkedin = $profile->linkedin ?? 'https://www.linkedin.com/';
        $phone    = $profile->phone    ?? '6281234567890';
        $twitter  = $profile->x        ?? 'https://x.com/'; // kolom "x" di Profile

        // 📍 Lokasi & Koordinat dari tabel profiles
        $location = $profile->location ?? 'Lokasi belum diatur';
        $lat      = $profile->lat ?? null;
        $lng      = $profile->lng ?? null;

        // Buat link WhatsApp internasional (hapus non-digit)
        $waDigits = preg_replace('/\D+/', '', $phone);
        $waLink   = $waDigits ? ('https://wa.me/' . $waDigits) : null;

        // Helper QR fallback (pakai layanan gratis apabila paket QR tidak ada)
        function qr_img_src($data, $size = 140, $margin = 1) {
            $q  = urlencode($data);
            $sz = $size . 'x' . $size;
            return "https://api.qrserver.com/v1/create-qr-code/?data={$q}&size={$sz}&margin={$margin}";
        }
    @endphp

    <header class="mb-8">
        <h1 class="text-3xl md:text-4xl font-bold leading-tight">
            Hubungi <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-500 to-emerald-500">Ammar Azmi</span>
        </h1>
        <p class="text-zinc-600 mt-1">Silakan kirim pesan melalui form di bawah, atau scan barcode di samping.</p>
    </header>

    {{-- Alerts --}}
    @if (session('success'))
        <div class="mb-6 rounded-2xl border border-emerald-200 bg-emerald-50 text-emerald-700 p-4 shadow-sm">
            {{ session('success') }}
        </div>
    @endif

    @if ($errors->any())
        <div class="mb-6 rounded-2xl border border-rose-200 bg-rose-50 text-rose-700 p-4 shadow-sm">
            <ul class="list-disc list-inside text-sm space-y-0.5">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="grid md:grid-cols-2 gap-8 items-start">
        {{-- FORM CARD --}}
        <form action="{{ route('contact.submit') }}" method="POST" class="space-y-5 rounded-2xl border bg-white p-6 shadow-sm">
            @csrf

            <div>
                <label class="text-[13px] font-medium text-zinc-800">Nama</label>
                <div class="mt-1 relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                        <svg class="size-5" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 9a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 21a8 8 0 0 1 16 0"/>
                        </svg>
                    </span>
                    <input type="text" name="name" value="{{ old('name') }}" required
                           class="w-full pl-10 pr-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500">
                </div>
            </div>

            <div>
                <label class="text-[13px] font-medium text-zinc-800">Email</label>
                <div class="mt-1 relative">
                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-zinc-400 pointer-events-none">
                        <svg class="size-5" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l9 6 9-6M4 8h16v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V8Z"/>
                        </svg>
                    </span>
                    <input type="email" name="email" value="{{ old('email') }}" required
                           class="w-full pl-10 pr-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500">
                </div>
            </div>

            {{-- PESAN (EasyMDE + scroll) --}}
            <div>
                <label class="text-[13px] font-medium text-zinc-800">Pesan</label>
                <div class="mt-1">
                    <textarea id="contact-message" name="message" required
                              class="w-full px-3 py-2.5 rounded-xl border bg-white shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500"
                              placeholder="Tulis pesanmu di sini…">{{ old('message') }}</textarea>
                </div>
                <p class="text-xs text-zinc-500 mt-1">
                    Markdown didukung. Gunakan tombol <em>Preview</em> di toolbar untuk melihat hasil; area editor &amp; preview dapat di-scroll.
                </p>
            </div>

            <div class="pt-1">
                <button type="submit" class="w-full md:w-auto px-5 py-2.5 rounded-xl bg-black text-white hover:opacity-90 shadow-sm">
                    Kirim Pesan
                </button>
            </div>
        </form>

        {{-- CONTACT CARDS + QRs --}}
        <div class="space-y-5">
            {{-- Banner: Peta Lokasi dari lat/lng --}}
            <div class="rounded-2xl overflow-hidden border bg-white shadow-sm">
                @if (!is_null($lat) && !is_null($lng))
                    <iframe
                        src="https://www.google.com/maps?q={{ $lat }},{{ $lng }}&hl=id&z=15&output=embed"
                        width="100%" height="300" style="border:0;" allowfullscreen loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                @else
                    <img
                        src="https://images.unsplash.com/photo-1519389950473-47ba0277781c?q=80&w=1600&auto=format&fit=crop"
                        alt="Contact" class="w-full object-cover aspect-[16/10]">
                @endif
            </div>
            @if (!is_null($lat) && !is_null($lng))
                <p class="text-sm text-zinc-600 mt-2 text-center">
                    📍 {{ $location }} ({{ number_format($lat, 6) }}, {{ number_format($lng, 6) }})
                </p>
            @endif

            {{-- Grid kartu kontak + QR --}}
            <div class="grid sm:grid-cols-4 gap-4">
                {{-- EMAIL --}}
                <div class="rounded-2xl border bg-white p-4 shadow-sm flex flex-col items-center text-center">
                    <div class="flex items-center gap-2 text-sm font-medium mb-2">
                        <svg class="size-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l9 6 9-6M4 8h16v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V8Z"/>
                        </svg>
                        Email
                    </div>
                    @if (class_exists(\SimpleSoftwareIO\QrCode\Facades\QrCode::class))
                        <div class="rounded-lg overflow-hidden border bg-white p-1">
                            {!! QrCode::size(140)->margin(1)->generate('mailto:' . $email) !!}
                        </div>
                    @else
                        <img class="rounded-lg border" width="140" height="140" src="{{ qr_img_src('mailto:' . $email, 140, 1) }}" alt="QR Email">
                    @endif
                    <a href="mailto:{{ $email }}" class="mt-2 text-sm text-indigo-600 hover:underline break-all">{{ $email }}</a>
                </div>

                {{-- LINKEDIN --}}
                <div class="rounded-2xl border bg-white p-4 shadow-sm flex flex-col items-center text-center">
                    <div class="flex items-center gap-2 text-sm font-medium mb-2">
                        <svg class="size-4" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1s2.48 1.12 2.48 2.5zM.5 8.5h4V23h-4V8.5zM8 8.5h3.8v2h.1c.5-.9 1.7-2.2 3.6-2.2 3.8 0 4.5 2.5 4.5 5.7V23h-4v-6.6c0-1.6 0-3.7-2.3-3.7-2.3 0-2.6 1.8-2.6 3.6V23H8V8.5z"/>
                        </svg>
                        LinkedIn
                    </div>
                    @if (class_exists(\SimpleSoftwareIO\QrCode\Facades\QrCode::class))
                        <div class="rounded-lg overflow-hidden border bg-white p-1">
                            {!! QrCode::size(140)->margin(1)->generate($linkedin) !!}
                        </div>
                    @else
                        <img class="rounded-lg border" width="140" height="140" src="{{ qr_img_src($linkedin, 140, 1) }}" alt="QR LinkedIn">
                    @endif
                    <a href="{{ $linkedin }}" target="_blank" rel="noopener" class="mt-2 text-sm text-indigo-600 hover:underline break-all">{{ $linkedin }}</a>
                </div>

                {{-- WHATSAPP --}}
                <div class="rounded-2xl border bg-white p-4 shadow-sm flex flex-col items-center text-center">
                    <div class="flex items-center gap-2 text-sm font-medium mb-2">
                        <svg class="size-4" fill="currentColor" viewBox="0 0 32 32" aria-hidden="true">
                            <path d="M19.11 17.36a4.74 4.74 0 0 1-2.14.52c-1 0-2.19-.23-3.53-1.39s-2.06-2.84-2.37-3.31a4.43 4.43 0 0 1-.52-2 2.31 2.31 0 0 1 .74-1.75 1 1 0 0 1 .75-.35h.54c.17 0 .41 0 .62.47.23.56.79 1.93.86 2.07s.13.3 0 .48-.2.29-.39.47-.41.41-.58.55-.12.31 0 .49a9.56 9.56 0 0 0 1.77 2.2 7.72 7.72 0 0 0 2.38 1.31c.2.08.32.07.44 0s.57-.67.73-.9.33-.19.55-.11 1.42.67 1.66.79.41.19.47.3a1.89 1.89 0 0 1-.11 1.09c-.19.54-.96.99-1.19 1.11Z"/>
                            <path d="M27.36 4.64A13.53 13.53 0 0 0 4.64 27.36L3 29l5.11-1.33A13.51 13.51 0 0 0 16 29.5H16A13.53 13.53 0 0 0 27.36 4.64Zm-1.41 21.31A11.57 11.57 0 0 1 16 27.5H16a11.44 11.44 0 0 1-5.9-1.6l-.42-.25-3.38.88.9-3.29-.27-.44A11.51 11.51 0 1 1 25.95 25.95Z"/>
                        </svg>
                        WhatsApp
                    </div>
                    @if ($waLink)
                        @if (class_exists(\SimpleSoftwareIO\QrCode\Facades\QrCode::class))
                            <div class="rounded-lg overflow-hidden border bg-white p-1">
                                {!! QrCode::size(140)->margin(1)->generate($waLink) !!}
                            </div>
                        @else
                            <img class="rounded-lg border" width="140" height="140" src="{{ qr_img_src($waLink, 140, 1) }}" alt="QR WhatsApp">
                        @endif
                        <a href="{{ $waLink }}" target="_blank" rel="noopener" class="mt-2 text-sm text-indigo-600 hover:underline break-all">{{ $waLink }}</a>
                    @else
                        <div class="text-sm text-zinc-500">Nomor WhatsApp belum tersedia.</div>
                    @endif
                </div>

                {{-- X (Twitter) --}}
                <div class="rounded-2xl border bg-white p-4 shadow-sm flex flex-col items-center text-center">
                    <div class="flex items-center gap-2 text-sm font-medium mb-2">
                        <svg class="size-4" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                            <path d="M18.244 2H21l-6.5 7.43L22.5 22H15.8l-5.06-6.64L4.84 22H2l6.96-7.96L1.5 2h6.86l4.56 5.98L18.244 2Zm-1.176 18h1.87L8.53 4h-1.9l10.44 16Z"/>
                        </svg>
                        X (Twitter)
                    </div>
                    @if (class_exists(\SimpleSoftwareIO\QrCode\Facades\QrCode::class))
                        <div class="rounded-lg overflow-hidden border bg-white p-1">
                            {!! QrCode::size(140)->margin(1)->generate($twitter) !!}
                        </div>
                    @else
                        <img class="rounded-lg border" width="140" height="140" src="{{ qr_img_src($twitter, 140, 1) }}" alt="QR X">
                    @endif
                    <a href="{{ $twitter }}" target="_blank" rel="noopener" class="mt-2 text-sm text-indigo-600 hover:underline break-all">{{ $twitter }}</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    {{-- Jika CSS EasyMDE belum diimport lewat JS global, biarkan link di bawah.
       Jika sudah di-import di app.js (import 'easymde/dist/easymde.min.css'), hapus baris ini agar tidak dobel. --}}
    <link rel="stylesheet" href="{{ Vite::asset('node_modules/easymde/dist/easymde.min.css') }}">

    <style>
        /* Batas tinggi editor dan jadikan scroll */
        .EasyMDEContainer .CodeMirror { max-height: 260px; overflow: auto !important; border-radius: 0.75rem; }
        .EasyMDEContainer .CodeMirror-scroll { max-height: 260px; }

        /* Preview bawaan EasyMDE agar scroll & nyaman dibaca */
        .EasyMDEContainer .editor-preview,
        .EasyMDEContainer .editor-preview-side {
            max-height: 260px; overflow: auto; padding: 0.75rem 1rem; background: #fff;
            border: 1px solid rgb(228 228 231); border-radius: 0.75rem;
        }

        /* Rapikan toolbar biar nyatu dengan style form */
        .EasyMDEContainer .editor-toolbar {
            border: 1px solid rgb(228 228 231); border-radius: 0.75rem; background: #fafafa;
        }

        /* Samakan border editor (tanpa ubah lebar) */
        .EasyMDEContainer .CodeMirror, .EasyMDEContainer .editor-statusbar {
            border: 1px solid rgb(228 228 231); border-radius: 0.75rem;
        }

        /* Fokus ring mirip input Tailwind-mu */
        .EasyMDEContainer .CodeMirror:focus-within { outline: 2px solid rgb(99 102 241); outline-offset: 2px; }
    </style>
@endpush

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const el = document.getElementById('contact-message');
            if (el && window.EasyMDE) {
                new window.EasyMDE({
                    element: el,
                    spellChecker: false,
                    autofocus: false,
                    autosave: false,
                    placeholder: 'Tulis pesanmu…',
                    minHeight: '180px',
                    status: false,
                    autoDownloadFontAwesome: false,
                    toolbar: ['bold','italic','heading','|','quote','unordered-list','ordered-list','|','link','preview','guide'],
                    renderingConfig: { singleLineBreaks: false }
                });
            }
        });
    </script>
@endpush
