@extends('frontend.layouts.app')

@section('content')
    {{-- HERO --}}
    <section class="grid lg:grid-cols-2 gap-8 items-center pt-4">
        <div class="space-y-6 [animation:fade-in_0.8s_ease-out_both]">
            <span
                class="inline-flex items-center gap-2 text-xs uppercase tracking-wider px-2 py-1 rounded-full bg-white/50 border">
                <span class="inline-block size-2 rounded-full bg-emerald-500 animate-ping"></span>
                Available for freelance
            </span>

            <h1 class="text-4xl md:text-5xl font-bold leading-tight">
                Hai, saya <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-500 to-emerald-500">Ammar
                    Azmi</span>.<br>
                Saya membangun website & aplikasi yang cepat, rapi, dan berkelas.
            </h1>

            <p class="text-lg text-zinc-600 max-w-prose">
                Full-stack dengan Laravel + Tailwind. Fokus ke aksesibilitas, performa, dan DX.
                Scroll ke bawah untuk lihat proyek unggulan.
            </p>

            <div class="flex flex-wrap gap-3">
                <a href="{{ route('projects.index') }}"
                    class="px-4 py-2 rounded-xl bg-black text-white hover:opacity-90 transition">Lihat Projects</a>
                <a href="#contact" class="px-4 py-2 rounded-xl border hover:shadow-sm">Hubungi Saya</a>
            </div>
        </div>

        @php
            /** @var \App\Models\Video|null $heroVideo */
            $v = $heroVideo ?? null;

            // Coba gunakan accessor jika ada; kalau tidak, ambil dari path storage
            $videoUrl = '';
            $posterUrl = 'https://images.unsplash.com/photo-1529101091764-c3526daf38fe?q=80&w=1200&auto=format&fit=crop';

            if ($v) {
                // accessor (jika kamu pakai di model): $v->url, $v->thumb_url
                if (isset($v->url) && $v->url) {
                    $videoUrl = $v->url;
                } elseif (!empty($v->file_path)) {
                    $videoUrl = \Illuminate\Support\Facades\Storage::disk('public')->url($v->file_path);
                }

                if (isset($v->thumb_url) && $v->thumb_url) {
                    $posterUrl = $v->thumb_url;
                } elseif (!empty($v->thumb_path)) {
                    $posterUrl = \Illuminate\Support\Facades\Storage::disk('public')->url($v->thumb_path);
                }
            }
        @endphp

        <div class="relative group [animation:fade-in-up_0.9s_0.1s_ease-out_both]">
            <div
                class="absolute -inset-4 rounded-3xl bg-gradient-to-tr from-indigo-400/30 via-sky-300/30 to-emerald-300/30 blur-2xl opacity-0 group-hover:opacity-100 transition">
            </div>

            <div class="relative rounded-2xl overflow-hidden border bg-white shadow-sm">
                @if($videoUrl)
                    {{-- Ada video dari database: tampilkan player --}}
                    <video
                        class="w-full aspect-video object-cover"
                        src="{{ $videoUrl }}"
                        poster="{{ $posterUrl }}"
                        autoplay
                        muted
                        loop
                        playsinline
                        controls
                    ></video>
                @else
                    {{-- Tidak ada video: tampilkan poster fallback --}}
                    <img
                        src="{{ $posterUrl }}"
                        alt="Poster"
                        class="w-full aspect-video object-cover">
                    <div class="absolute inset-0 grid place-items-center">
                        <span class="px-3 py-1.5 rounded-xl text-sm bg-white/90 border text-zinc-700">
                            Belum ada video yang diunggah
                        </span>
                    </div>
                @endif
            </div>
        </div>
    </section>

    {{-- STATS (dinamis) --}}
    <section class="grid grid-cols-2 sm:grid-cols-4 gap-4 mt-10 [animation:fade-in-up_0.8s_0.2s_both]">
        <div class="rounded-2xl border bg-white p-5 text-center shadow-sm">
            <div class="text-3xl font-bold">{{ number_format($projectCount) }}</div>
            <div class="text-sm text-zinc-600">Project</div>
        </div>

        <div class="rounded-2xl border bg-white p-5 text-center shadow-sm">
            <div class="text-3xl font-bold">{{ rtrim(rtrim(number_format($yearsFloat, 1), '0'), '.') }} th</div>
            <div class="text-sm text-zinc-600">Pengalaman</div>
        </div>

        <div class="rounded-2xl border bg-white p-5 text-center shadow-sm">
            <div class="text-3xl font-bold">{{ number_format($uniqueUsers) }}</div>
            <div class="text-sm text-zinc-600">Users</div>
        </div>

        <div class="rounded-2xl border bg-white p-5 text-center shadow-sm">
            <div class="text-3xl font-bold">{{ $grade }}</div>
            <div class="text-sm text-zinc-600">Performance</div>
        </div>
    </section>

    {{-- FEATURED PROJECT --}}
    <section class="mt-16 space-y-6">
        <div class="flex items-end justify-between gap-4">
            <h2 class="text-2xl font-semibold">Proyek Unggulan</h2>
            <a href="{{ route('projects.index') }}" class="text-sm underline">Semua proyek →</a>
        </div>

        <div class="grid md:grid-cols-2 gap-6">
            <a href="{{ route('projects.index') }}"
                class="group rounded-2xl overflow-hidden border bg-white shadow-sm hover:shadow-md transition">
                <img src="https://images.unsplash.com/photo-1461749280684-dccba630e2f6?q=80&w=1600&auto=format&fit=crop"
                    class="w-full aspect-[16/10] object-cover group-hover:scale-[1.02] transition" alt="project cover">
                <div class="p-5 space-y-2">
                    <div class="text-xs text-zinc-500">Laravel • Filament • Tailwind</div>
                    <h3 class="font-semibold text-lg">SaaS Dashboard & CMS</h3>
                    <p class="text-sm text-zinc-600">Membangun dashboard analitik real-time dengan CRUD dinamis.</p>
                </div>
            </a>

            <a href="{{ route('projects.index') }}"
                class="group rounded-2xl overflow-hidden border bg-white shadow-sm hover:shadow-md transition">
                <img src="https://images.unsplash.com/photo-1555066931-4365d14bab8c?q=80&w=1600&auto=format&fit=crop"
                    class="w-full aspect-[16/10] object-cover group-hover:scale-[1.02] transition" alt="project cover">
                <div class="p-5 space-y-2">
                    <div class="text-xs text-zinc-500">Next.js • API • Tailwind</div>
                    <h3 class="font-semibold text-lg">Marketing Site Super Cepat</h3>
                    <p class="text-sm text-zinc-600">Lighthouse A+ dan TTFB rendah untuk SEO maksimal.</p>
                </div>
            </a>
        </div>
    </section>

    {{-- SKILLS MARQUEE --}}
    <section id="about" class="mt-16">
        <h2 class="text-2xl font-semibold mb-6">Skill & Tools</h2>

        <div class="relative overflow-hidden rounded-2xl border bg-white">
            @php $dup = $skills->count() <= 15 ? 3 : 2; @endphp
            <div class="marquee-track whitespace-nowrap">
                @for ($i = 0; $i < $dup; $i++)
                    <div class="marquee-group" @if ($i > 0) aria-hidden="true" @endif>
                        @foreach ($skills as $skill)
                            <span class="text-sm px-3 py-1.5 rounded-xl bg-zinc-100 inline-flex items-center gap-2">
                                @if ($skill->icon)
                                    <i class="{{ $skill->icon }}"></i>
                                @endif
                                {{ $skill->name }}
                            </span>
                        @endforeach
                    </div>
                @endfor
            </div>
        </div>
    </section>

    {{-- CONTACT --}}
    <section id="contact" class="mt-16 grid md:grid-cols-2 gap-6 items-center">
        <div class="space-y-3">
            <h2 class="text-2xl font-semibold">Ada proyek menarik?</h2>
            <p class="text-zinc-600">Saya siap bantu dari desain sistem, arsitektur backend, hingga front-end yang mulus.
            </p>
            <div class="flex gap-3">
                <a href="mailto:hello@example.com" class="px-4 py-2 rounded-xl bg-black text-white hover:opacity-90">Email
                    Saya</a>
                <a href="https://wa.me/6281234567890" target="_blank"
                    class="px-4 py-2 rounded-xl border hover:shadow-sm">WhatsApp</a>
            </div>
        </div>
        <div class="rounded-2xl overflow-hidden border bg-white shadow-sm">
            <img src="https://images.unsplash.com/photo-1515879218367-8466d910aaa4?q=80&w=1600&auto=format&fit=crop"
                alt="workspace" class="w-full object-cover aspect-[16/10]">
        </div>
    </section>

    {{-- Inline CSS (kecil & khusus halaman ini) --}}
    <style>
        /* Animations */
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(4px) }
            to   { opacity: 1; transform: none }
        }
        @keyframes fade-in-up {
            from { opacity: 0; transform: translateY(12px) }
            to   { opacity: 1; transform: none }
        }

        /* Marquee: 2/3 blok identik → geser 50% untuk loop mulus */
        @keyframes marquee {
            0%   { transform: translateX(0) }
            100% { transform: translateX(-50%) }
        }
        .marquee-track { display:flex; width:max-content; animation: marquee 18s linear infinite; }
        .marquee-group { display:flex; gap:2.5rem; padding:1.25rem; align-items:center; }

        @media (prefers-reduced-motion: reduce) {
            .marquee-track { animation:none; transform:none; }
        }
    </style>
@endsection
