<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>{{ $title ?? 'Portofolio — Ammar Azmi' }}</title>
    <meta name="description" content="Portofolio Ammar Azmi — proyek, skill, dan kontak.">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="min-h-dvh bg-zinc-50 text-zinc-900 antialiased selection:bg-black selection:text-white">
    <!-- Background blob animasi -->
    <div aria-hidden="true" class="pointer-events-none fixed inset-0 -z-10 overflow-hidden">
        <div
            class="absolute -top-32 -left-32 h-96 w-96 rounded-full blur-3xl opacity-20 bg-gradient-to-tr from-indigo-400 via-sky-400 to-emerald-400 animate-pulse">
        </div>
        <div
            class="absolute -bottom-40 -right-28 h-[28rem] w-[28rem] rounded-full blur-3xl opacity-20 bg-gradient-to-br from-fuchsia-400 via-rose-400 to-amber-300 animate-[pulse_8s_ease-in-out_infinite]">
        </div>
    </div>

    <!-- Header -->
    <header class="sticky top-0 z-50 bg-white/70 backdrop-blur border-b border-zinc-100">
        <nav class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
            <a href="{{ route('home') }}" class="font-semibold tracking-tight">Ammar • Portfolio</a>

            <button id="menuBtn" class="md:hidden p-2 rounded-lg border hover:bg-zinc-50" aria-label="Toggle menu">
                <!-- icon -->
                <svg xmlns="http://www.w3.org/2000/svg" class="size-5" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                        d="M4 6h16M4 12h16M4 18h16" />
                </svg>
            </button>

            <div id="menu" class="hidden md:flex items-center gap-4">
                <a href="{{ route('projects.index') }}"
                    class="{{ request()->routeIs('projects.*') ? 'underline font-medium' : 'hover:underline' }}">
                    Projects
                </a>

                <a href="{{ route('about') }}"
                    class="{{ request()->routeIs('about') ? 'underline font-medium' : 'hover:underline' }}">
                    About
                </a>

                <a href="{{ route('contact.show') }}"
                    class="{{ request()->routeIs('contact.*') ? 'underline font-medium' : 'hover:underline' }}">
                    Contact
                </a>

                @php
                    $activeCv = \App\Models\Cv::whereNotNull('published_at')->orderByDesc('published_at')->first();
                @endphp

                @if ($activeCv)
                    <a href="{{ method_exists($activeCv, 'getUrlAttribute') ? $activeCv->url : asset('storage/' . $activeCv->file_path) }}"
                        target="_blank" rel="noreferrer" class="px-3 py-1.5 rounded-xl border hover:shadow-sm">
                        Download CV
                    </a>
                @else
                    <button type="button" disabled
                        class="px-3 py-1.5 rounded-xl border text-zinc-400 cursor-not-allowed">
                        CV belum tersedia
                    </button>
                @endif

            </div>
        </nav>


        <!-- Mobile menu -->
        <div id="menuMobile" class="md:hidden hidden border-t bg-white">
            <div class="max-w-6xl mx-auto px-4 py-3 flex flex-col gap-3">
                <a href="{{ route('projects.index') }}">Projects</a>
                <a href="{{ route('about') }}">About</a>
                <a href="{{ route('contact.show') }}">Contact</a>
                <a href="{{ asset('cv.pdf') }}" target="_blank" rel="noreferrer">Download CV</a>
            </div>
        </div>
    </header>

    <!-- Main -->
    <main class="max-w-6xl mx-auto px-4 py-10">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="border-t bg-white/70 backdrop-blur">
        <div
            class="max-w-6xl mx-auto px-4 py-6 text-sm text-zinc-600 flex flex-col sm:flex-row items-center justify-between gap-2">
            <p>© {{ date('Y') }} Ammar Azmi. All rights reserved.</p>
            <div class="flex items-center gap-3">
                <a href="https://github.com/ammarazmi" target="_blank" rel="noreferrer"
                    class="hover:underline">GitHub</a>
                <a href="https://www.linkedin.com/in/ammar-azmi-23b33b129" target="_blank" rel="noreferrer"
                    class="hover:underline">LinkedIn</a>
                <a href="mailto:{{ config('mail.from.address') ?? 'hello@example.com' }}"
                    class="hover:underline">Email</a>
            </div>
        </div>
    </footer>
</body>

</html>
