@extends('frontend.layouts.app')

@section('content')
<div class="relative">
  {{-- Header hero kecil --}}
  <div class="bg-gradient-to-br from-indigo-600 via-violet-600 to-fuchsia-600">
    <div class="max-w-6xl mx-auto px-4 py-10">
      <h1 class="text-2xl md:text-3xl font-bold text-white tracking-tight">Projects</h1>
      <p class="text-white/80 mt-1">Terbaru minggu ini & paling banyak dilihat.</p>
    </div>
  </div>

  <div class="max-w-6xl mx-auto px-4 py-8 space-y-12">

    {{-- TERBARU 7 HARI --}}
    <section>
      <div class="flex items-end justify-between mb-4">
        <h2 class="text-lg font-semibold text-zinc-900">🔥 Terbaru (7 Hari)</h2>
      </div>
      @if($latestWeek->isEmpty())
        <p class="text-zinc-500 text-sm">Belum ada project baru minggu ini.</p>
      @else
        <div class="grid gap-5 sm:grid-cols-2 lg:grid-cols-3">
          @foreach($latestWeek as $p)
            <x-project-card :project="$p" />
          @endforeach
        </div>
      @endif
    </section>

    {{-- PALING BANYAK DILIHAT --}}
    <section>
      <div class="flex items-end justify-between mb-4">
        <h2 class="text-lg font-semibold text-zinc-900">📈 Paling Banyak Dilihat</h2>
      </div>
      @if($mostViewed->isEmpty())
        <p class="text-zinc-500 text-sm">Belum ada data tayangan.</p>
      @else
        <div class="grid gap-5 sm:grid-cols-2 lg:grid-cols-3">
          @foreach($mostViewed as $p)
            <x-project-card :project="$p" />
          @endforeach
        </div>
      @endif
    </section>

    {{-- SEMUA PROJECT --}}
    <section>
      <div class="flex items-end justify-between mb-4">
        <h2 class="text-lg font-semibold text-zinc-900">🗂️ Semua Project</h2>
      </div>
      @if($projects->isEmpty())
        <p class="text-zinc-500 text-sm">Belum ada project.</p>
      @else
        <div class="grid gap-5 sm:grid-cols-2 lg:grid-cols-3">
          @foreach($projects as $p)
            <x-project-card :project="$p" />
          @endforeach
        </div>
        <div class="mt-6">{{ $projects->links() }}</div>
      @endif
    </section>

  </div>
</div>
@endsection
